/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.stats.StatList;
import net.minecraft.util.ResourceLocation;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.GameRegistry;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.value.ValueFactory;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.ai.task.AITaskType;
import org.spongepowered.api.entity.ai.task.AbstractAITask;
import org.spongepowered.api.entity.living.Agent;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.merchant.VillagerRegistry;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipeRegistry;
import org.spongepowered.api.item.recipe.smelting.SmeltingRecipeRegistry;
import org.spongepowered.api.network.status.Favicon;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.ExtraClassCatalogRegistryModule;
import org.spongepowered.api.registry.RegistrationPhase;
import org.spongepowered.api.registry.RegistryModule;
import org.spongepowered.api.registry.RegistryModuleAlreadyRegisteredException;
import org.spongepowered.api.registry.util.PluginProvidedRegistryModule;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.statistic.BlockStatistic;
import org.spongepowered.api.statistic.EntityStatistic;
import org.spongepowered.api.statistic.ItemStatistic;
import org.spongepowered.api.statistic.StatisticType;
import org.spongepowered.api.statistic.StatisticTypes;
import org.spongepowered.api.text.BookView;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.serializer.BookViewDataBuilder;
import org.spongepowered.api.text.serializer.TextConfigSerializer;
import org.spongepowered.api.text.serializer.TextSerializerFactory;
import org.spongepowered.api.text.serializer.TextTemplateConfigSerializer;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.rotation.Rotation;
import org.spongepowered.api.world.extent.ExtentBufferFactory;
import org.spongepowered.api.world.gamerule.DefaultGameRules;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.CatalogTypeTypeSerializer;
import org.spongepowered.common.data.DataRegistrar;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.registry.SpongeGameRegistryRegisterEvent;
import org.spongepowered.common.item.recipe.crafting.SpongeCraftingRecipeRegistry;
import org.spongepowered.common.network.status.SpongeFavicon;
import org.spongepowered.common.registry.CommonModuleRegistry;
import org.spongepowered.common.registry.CustomRegistrationPhase;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.registry.SpongeVillagerRegistry;
import org.spongepowered.common.registry.type.block.RotationRegistryModule;
import org.spongepowered.common.registry.type.entity.AITaskTypeModule;
import org.spongepowered.common.registry.type.scoreboard.DisplaySlotRegistryModule;
import org.spongepowered.common.registry.util.RegistryModuleLoader;
import org.spongepowered.common.text.selector.SpongeSelectorFactory;
import org.spongepowered.common.text.serializer.SpongeTextSerializerFactory;
import org.spongepowered.common.text.translation.SpongeTranslation;
import org.spongepowered.common.util.LocaleCache;
import org.spongepowered.common.util.SetSerializer;
import org.spongepowered.common.util.graph.CyclicGraphException;
import org.spongepowered.common.util.graph.DirectedGraph;
import org.spongepowered.common.util.graph.TopologicalOrder;
import org.spongepowered.common.world.extent.SpongeExtentBufferFactory;

@Singleton
public class SpongeGameRegistry
implements GameRegistry {
    private static final boolean PRINT_CATALOG_TYPES = Boolean.parseBoolean(System.getProperty("sponge.print_all_catalog_types"));
    private RegistrationPhase phase = RegistrationPhase.PRE_REGISTRY;
    protected static final Map<Class<? extends CatalogType>, CatalogRegistryModule<?>> REGISTRY_MAP;
    private static final Map<Class<?>, Supplier<?>> BUILDER_SUPPLIERS;
    private static List<Class<? extends RegistryModule>> ORDERED_MODULES;
    private static Map<Class<? extends RegistryModule>, RegistryModule> REGISTRY_CLASS_MAP;
    private static Map<CatalogRegistryModule<?>, Class<? extends CatalogType>> REGISTRY_CATALOG_MAP;
    private static Set<RegistryModule> REGISTRIES;
    private static List<Class<? extends RegistryModule>> MODULES;

    @Inject
    public SpongeGameRegistry() {
    }

    public final RegistrationPhase getPhase() {
        return this.phase;
    }

    public void preRegistryInit() {
        CommonModuleRegistry.getInstance().registerDefaultModules();
        this.syncModules();
        this.registerModulePhase();
        SpongeVillagerRegistry.registerVanillaTrades();
        DataRegistrar.setupSerialization();
        if (PRINT_CATALOG_TYPES) {
            ArrayList<Tuple> modules = new ArrayList<Tuple>();
            for (Map.Entry<Class<CatalogType>, CatalogRegistryModule<?>> entry : REGISTRY_MAP.entrySet()) {
                modules.add(new Tuple(entry.getKey(), entry.getValue()));
            }
            modules.sort(Comparator.comparing(tuple -> ((Class)tuple.getFirst()).getSimpleName()));
            PrettyPrinter printer = new PrettyPrinter(100).add("Printing all Catalogs and their ID's").centre().hr().addWrapped("This is a test to print out all registered catalogs during initialization for their mapping, id's, and objects themselves.", new Object[0]);
            for (Tuple module : modules) {
                printer.add(" %s : %s", "CatalogType", ((Class)module.getFirst()).getSimpleName());
                Collection all = ((CatalogRegistryModule)module.getSecond()).getAll();
                ArrayList catalogTypes = new ArrayList(all);
                catalogTypes.sort(Comparator.comparing(CatalogType::getId));
                for (CatalogType catalogType : catalogTypes) {
                    printer.add("  -%s", catalogType.getId());
                }
                printer.hr();
            }
            printer.trace(System.err, SpongeImpl.getLogger(), Level.DEBUG);
        }
    }

    public void preInit() {
        this.phase = RegistrationPhase.PRE_INIT;
        this.syncModules();
        this.registerModulePhase();
    }

    public void init() {
        this.phase = RegistrationPhase.INIT;
        this.syncModules();
        this.registerInitModulePhase();
    }

    public void postInit() {
        this.phase = RegistrationPhase.POST_INIT;
        this.syncModules();
        this.registerModulePhase();
        SpongeImpl.getPropertyRegistry().completeRegistration();
        SpongeDataManager.finalizeRegistration();
        this.phase = RegistrationPhase.LOADED;
        for (RegistryModule module : REGISTRIES) {
            SpongeImpl.getLogger().error("Failed to register {}", (Object)module);
        }
    }

    private void registerInitModulePhase() {
        for (Class<? extends RegistryModule> moduleClass : MODULES) {
            RegistryModule module = REGISTRY_CLASS_MAP.get(moduleClass);
            Preconditions.checkState((module != null ? 1 : 0) != 0, (Object)"Something funky happened!");
            if (REGISTRIES.contains(module) && RegistryModuleLoader.tryModulePhaseRegistration(module)) {
                REGISTRIES.remove(module);
            }
            if (!ShouldFire.GAME_REGISTRY_EVENT_REGISTER) continue;
            this.throwRegistryEvent(module);
        }
        this.registerAdditionalPhase();
        MODULES = null;
    }

    private void registerModulePhase() {
        for (Class<? extends RegistryModule> moduleClass : ORDERED_MODULES) {
            RegistryModule module = REGISTRY_CLASS_MAP.get(moduleClass);
            Preconditions.checkState((module != null ? 1 : 0) != 0, (Object)"Something funky happened!");
            if (!RegistryModuleLoader.tryModulePhaseRegistration(module)) continue;
            REGISTRIES.remove(module);
        }
        this.registerAdditionalPhase();
    }

    private void registerAdditionalPhase() {
        for (RegistryModule module : REGISTRY_CLASS_MAP.values()) {
            RegistryModuleLoader.tryAdditionalRegistration(module);
        }
    }

    @Override
    public <T extends CatalogType> SpongeGameRegistry registerModule(Class<T> catalogClass, CatalogRegistryModule<T> registryModule) {
        CatalogRegistryModule<?> existingModule = REGISTRY_MAP.get(catalogClass);
        if (existingModule != null) {
            throw new RegistryModuleAlreadyRegisteredException("Already registered a registry module!", existingModule);
        }
        REGISTRY_MAP.put(catalogClass, registryModule);
        REGISTRY_CATALOG_MAP.put(registryModule, catalogClass);
        REGISTRIES.add(registryModule);
        REGISTRY_CLASS_MAP.put(registryModule.getClass(), registryModule);
        if (!ORDERED_MODULES.isEmpty() && catalogClass.getName().contains("org.spongepowered.api") && catalogClass.getAnnotation(PluginProvidedRegistryModule.class) == null) {
            throw new UnsupportedOperationException("Cannot register a module for an API defined class! That's the implementation's job!");
        }
        return this;
    }

    @Override
    public SpongeGameRegistry registerModule(RegistryModule module) {
        Preconditions.checkNotNull((Object)module);
        Preconditions.checkArgument((!REGISTRY_CLASS_MAP.containsKey(module.getClass()) ? 1 : 0) != 0);
        REGISTRIES.add(module);
        REGISTRY_CLASS_MAP.put(module.getClass(), module);
        return this;
    }

    private void syncModules() {
        DirectedGraph<Class<? extends RegistryModule>> graph = new DirectedGraph<Class<? extends RegistryModule>>();
        for (RegistryModule module : REGISTRIES) {
            this.addToGraph(module, graph);
        }
        ORDERED_MODULES.clear();
        try {
            ORDERED_MODULES.addAll(TopologicalOrder.createOrderedLoad(graph));
            if (MODULES != null) {
                MODULES.addAll(ORDERED_MODULES);
            }
        }
        catch (CyclicGraphException e) {
            StringBuilder msg = new StringBuilder();
            msg.append("Registry module dependencies are cyclical!\n");
            msg.append("Dependency loops are:\n");
            for (DirectedGraph.DataNode<?>[] cycle : e.getCycles()) {
                msg.append("[");
                for (DirectedGraph.DataNode<?> node : cycle) {
                    msg.append(node.getData().toString()).append(" ");
                }
                msg.append("]\n");
            }
            SpongeImpl.getLogger().fatal(msg.toString());
            throw new RuntimeException("Registry modules dependencies error.");
        }
    }

    @Override
    public <T> SpongeGameRegistry registerBuilderSupplier(Class<T> builderClass, Supplier<? extends T> supplier) {
        Preconditions.checkArgument((!BUILDER_SUPPLIERS.containsKey(builderClass) ? 1 : 0) != 0, (Object)"Already registered a builder supplier!");
        BUILDER_SUPPLIERS.put(builderClass, supplier);
        return this;
    }

    private <T extends CatalogType> Optional<CatalogRegistryModule<T>> getRegistryModuleFor(Class<T> catalogClass) {
        Preconditions.checkNotNull(catalogClass);
        return Optional.ofNullable(REGISTRY_MAP.get(catalogClass));
    }

    public <TUnknown, T extends CatalogType> T getTranslated(Class<TUnknown> clazz, Class<T> catalogClazz) {
        CatalogRegistryModule module = this.getRegistryModuleFor(catalogClazz).orElse(null);
        Preconditions.checkArgument((boolean)(module instanceof ExtraClassCatalogRegistryModule));
        ExtraClassCatalogRegistryModule classModule = (ExtraClassCatalogRegistryModule)module;
        return classModule.getForClass(clazz);
    }

    @Override
    public <T extends CatalogType> Optional<T> getType(Class<T> typeClass, String id) {
        CatalogRegistryModule registryModule = this.getRegistryModuleFor(typeClass).orElse(null);
        if (registryModule == null) {
            return Optional.empty();
        }
        return registryModule.getById(id.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public <T extends CatalogType> Collection<T> getAllOf(Class<T> typeClass) {
        CatalogRegistryModule registryModule = this.getRegistryModuleFor(typeClass).orElse(null);
        if (registryModule == null) {
            return Collections.emptyList();
        }
        return registryModule.getAll();
    }

    @Override
    public <T extends CatalogType> Collection<T> getAllFor(String pluginId, Class<T> typeClass) {
        Preconditions.checkNotNull((Object)pluginId);
        CatalogRegistryModule registryModule = this.getRegistryModuleFor(typeClass).orElse(null);
        if (registryModule == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        registryModule.getAll().stream().filter(type -> pluginId.equals(type.getId().split(":")[0])).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    public <T extends ResettableBuilder<?, ? super T>> T createBuilder(Class<T> builderClass) {
        Preconditions.checkNotNull(builderClass, (Object)"Builder class was null!");
        Supplier<?> supplier = BUILDER_SUPPLIERS.get(builderClass);
        Preconditions.checkArgument((supplier != null ? 1 : 0) != 0, (Object)("Could not find a Supplier for the provided builder class: " + builderClass.getCanonicalName()));
        return (T)((ResettableBuilder)supplier.get());
    }

    @Override
    public <T extends CatalogType> T register(Class<T> type, T obj) throws IllegalArgumentException, UnsupportedOperationException {
        CatalogRegistryModule registryModule = this.getRegistryModuleFor(type).orElse(null);
        if (registryModule == null) {
            throw new UnsupportedOperationException("Failed to find a RegistryModule for that type");
        }
        if (registryModule instanceof SpongeAdditionalCatalogRegistryModule) {
            if (((SpongeAdditionalCatalogRegistryModule)registryModule).allowsApiRegistration()) {
                ((SpongeAdditionalCatalogRegistryModule)registryModule).registerAdditionalCatalog(obj);
                return obj;
            }
        } else if (registryModule instanceof AdditionalCatalogRegistryModule) {
            ((AdditionalCatalogRegistryModule)registryModule).registerAdditionalCatalog(obj);
            return obj;
        }
        throw new UnsupportedOperationException("This catalog type does not support additional registration");
    }

    public List<String> getDefaultGameRules() {
        ArrayList<String> gameruleList = new ArrayList<String>();
        for (Field f : DefaultGameRules.class.getFields()) {
            try {
                gameruleList.add((String)f.get(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return gameruleList;
    }

    @Override
    public Optional<EntityStatistic> getEntityStatistic(StatisticType statType, EntityType entityType) {
        Preconditions.checkNotNull((Object)statType, (Object)"null stat type");
        Preconditions.checkNotNull((Object)entityType, (Object)"null entity type");
        EntityList.EntityEggInfo eggInfo = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(new ResourceLocation(entityType.getId()));
        if (statType.equals(StatisticTypes.ENTITIES_KILLED)) {
            return Optional.of((EntityStatistic)eggInfo.field_151512_d);
        }
        if (statType.equals(StatisticTypes.KILLED_BY_ENTITY)) {
            return Optional.of((EntityStatistic)eggInfo.field_151513_e);
        }
        throw new IllegalArgumentException("invalid entity stat type");
    }

    @Override
    public Optional<ItemStatistic> getItemStatistic(StatisticType statType, ItemType itemType) {
        Preconditions.checkNotNull((Object)statType, (Object)"null stat type");
        Preconditions.checkNotNull((Object)itemType, (Object)"null item type");
        Item item = (Item)itemType;
        if (statType.equals(StatisticTypes.ITEMS_CRAFTED)) {
            return Optional.of((ItemStatistic)StatList.func_188060_a((Item)item));
        }
        if (statType.equals(StatisticTypes.ITEMS_USED)) {
            return Optional.of((ItemStatistic)StatList.func_188057_b((Item)item));
        }
        if (statType.equals(StatisticTypes.ITEMS_BROKEN)) {
            return Optional.of((ItemStatistic)StatList.func_188059_c((Item)item));
        }
        if (statType.equals(StatisticTypes.ITEMS_PICKED_UP)) {
            return Optional.of((ItemStatistic)StatList.func_188056_d((Item)item));
        }
        if (statType.equals(StatisticTypes.ITEMS_DROPPED)) {
            return Optional.of((ItemStatistic)StatList.func_188058_e((Item)item));
        }
        throw new IllegalArgumentException("invalid item stat type");
    }

    @Override
    public Optional<BlockStatistic> getBlockStatistic(StatisticType statType, BlockType blockType) {
        if (!statType.equals(StatisticTypes.BLOCKS_BROKEN)) {
            throw new IllegalArgumentException("invalid block stat type");
        }
        return Optional.of((BlockStatistic)StatList.func_188055_a((Block)((Block)blockType)));
    }

    @Override
    public AITaskType registerAITaskType(Object plugin, String id, String name, Class<? extends AbstractAITask<? extends Agent>> aiClass) {
        return AITaskTypeModule.getInstance().createAITaskType(plugin, id, name, aiClass);
    }

    @Override
    public Optional<Rotation> getRotationFromDegree(int degrees) {
        return RotationRegistryModule.getInstance().getRotationFromDegree(degrees);
    }

    @Override
    public Favicon loadFavicon(String raw) throws IOException {
        return SpongeFavicon.load(raw);
    }

    @Override
    public Favicon loadFavicon(Path path) throws IOException {
        return SpongeFavicon.load(path);
    }

    @Override
    public Favicon loadFavicon(URL url) throws IOException {
        return SpongeFavicon.load(url);
    }

    @Override
    public Favicon loadFavicon(InputStream in) throws IOException {
        return SpongeFavicon.load(in);
    }

    @Override
    public Favicon loadFavicon(BufferedImage image) throws IOException {
        return SpongeFavicon.load(image);
    }

    @Override
    public CraftingRecipeRegistry getCraftingRecipeRegistry() {
        return SpongeCraftingRecipeRegistry.getInstance();
    }

    @Override
    public SmeltingRecipeRegistry getSmeltingRecipeRegistry() {
        return (SmeltingRecipeRegistry)FurnaceRecipes.func_77602_a();
    }

    @Override
    public Optional<Translation> getTranslationById(String id) {
        return Optional.of(new SpongeTranslation(id));
    }

    @Override
    public Optional<ResourcePack> getResourcePackById(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<DisplaySlot> getDisplaySlotForColor(TextColor color) {
        return Optional.ofNullable(DisplaySlotRegistryModule.getInstance().displaySlotMappings.get(color.getId()));
    }

    @Override
    public ExtentBufferFactory getExtentBufferFactory() {
        return SpongeExtentBufferFactory.INSTANCE;
    }

    @Override
    public ValueFactory getValueFactory() {
        return SpongeValueFactory.getInstance();
    }

    @Override
    public VillagerRegistry getVillagerRegistry() {
        return SpongeVillagerRegistry.getInstance();
    }

    @Override
    public TextSerializerFactory getTextSerializerFactory() {
        return SpongeTextSerializerFactory.INSTANCE;
    }

    @Override
    public SpongeSelectorFactory getSelectorFactory() {
        return SpongeSelectorFactory.INSTANCE;
    }

    @Override
    public Locale getLocale(String locale) {
        return LocaleCache.getLocale(locale);
    }

    private void addToGraph(RegistryModule module, DirectedGraph<Class<? extends RegistryModule>> graph) {
        Preconditions.checkNotNull(module.getClass(), (Object)"Dependency class was null!");
        graph.add(module.getClass());
        RegistrationDependency dependency = module.getClass().getAnnotation(RegistrationDependency.class);
        if (dependency != null) {
            for (Class<? extends RegistryModule> dependent : dependency.value()) {
                graph.addEdge(module.getClass(), dependent);
            }
        }
    }

    public void registerAdditionals() {
        this.registerAdditionalPhase();
    }

    public static void clear() {
        ORDERED_MODULES = null;
        REGISTRY_CLASS_MAP = null;
        REGISTRY_CATALOG_MAP = null;
        REGISTRIES = null;
        MODULES = null;
    }

    private void throwRegistryEvent(RegistryModule module) {
        Class<? extends CatalogType> catalog = REGISTRY_CATALOG_MAP.get(module);
        this.throwRegistryEvent(catalog, module);
    }

    private void throwRegistryEvent(Class<? extends CatalogType> catalogClass, RegistryModule module) {
        if (module instanceof AdditionalCatalogRegistryModule && (!(module instanceof SpongeAdditionalCatalogRegistryModule) || ((SpongeAdditionalCatalogRegistryModule)module).allowsApiRegistration()) && module.getClass().getAnnotation(CustomRegistrationPhase.class) == null) {
            if (catalogClass == null) {
                new PrettyPrinter(60).centre().add("Unregistered RegistryModule").hr().addWrapped(60, "An unknown registry module was added to the ordered set of modules, but the module itself is not registered with the GameRegistry!", new Object[0]).add().add("%s : %s", "Registry Module", module.toString()).add().add(new Exception()).add().add("To fix this, the developer providing the module needs to register the module correctly.").trace();
                return;
            }
            AdditionalCatalogRegistryModule registryModule = (AdditionalCatalogRegistryModule)module;
            SpongeImpl.postEvent(new SpongeGameRegistryRegisterEvent<CatalogType>(Sponge.getCauseStackManager().getCurrentCause(), catalogClass, registryModule));
        }
    }

    static {
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(CatalogType.class), new CatalogTypeTypeSerializer());
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(Text.class), new TextConfigSerializer());
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(BookView.class), new BookViewDataBuilder());
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(TextTemplate.class), new TextTemplateConfigSerializer());
        TypeSerializers.getDefaultSerializers().registerType(new TypeToken<Set<?>>(){
            public static final long serialVersionUID = 1L;
        }, new SetSerializer());
        REGISTRY_MAP = new IdentityHashMap();
        BUILDER_SUPPLIERS = new IdentityHashMap();
        ORDERED_MODULES = new ArrayList<Class<? extends RegistryModule>>();
        REGISTRY_CLASS_MAP = new IdentityHashMap<Class<? extends RegistryModule>, RegistryModule>();
        REGISTRY_CATALOG_MAP = new HashMap();
        REGISTRIES = new HashSet<RegistryModule>();
        MODULES = new ArrayList<Class<? extends RegistryModule>>();
    }
}

