/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.scheduler.ScheduledTask;
import org.spongepowered.common.scheduler.SchedulerBase;

public class AsyncScheduler
extends SchedulerBase {
    private long minimumTimeout = Long.MAX_VALUE;
    private long lastProcessingTimestamp;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final AtomicBoolean stateChanged = new AtomicBoolean(false);
    private final ExecutorService executor = Executors.newCachedThreadPool();

    AsyncScheduler() {
        super(ScheduledTask.TaskSynchronicity.ASYNCHRONOUS);
        Thread thread = new Thread(this::mainLoop);
        thread.setName("Sponge Async Scheduler Thread");
        thread.setDaemon(true);
        thread.start();
    }

    ExecutorService getExecutor() {
        return this.executor;
    }

    private void mainLoop() {
        this.lastProcessingTimestamp = System.nanoTime();
        while (true) {
            this.recalibrateMinimumTimeout();
            this.runTick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalibrateMinimumTimeout() {
        this.lock.lock();
        try {
            Set<Task> tasks = this.getScheduledTasks();
            this.minimumTimeout = Long.MAX_VALUE;
            long now = System.nanoTime();
            for (Task tmpTask : tasks) {
                ScheduledTask task = (ScheduledTask)tmpTask;
                if (task.getState() == ScheduledTask.ScheduledTaskState.EXECUTING) continue;
                if (task.offset == 0L && task.period == 0L) {
                    this.minimumTimeout = 0L;
                }
                long timeSinceLast = now - task.getTimestamp();
                if (task.offset > 0L && task.getState() == ScheduledTask.ScheduledTaskState.WAITING) {
                    this.minimumTimeout = Math.min(task.offset - timeSinceLast, this.minimumTimeout);
                }
                if (task.period > 0L && task.getState().isActive) {
                    this.minimumTimeout = Math.min(task.period - timeSinceLast, this.minimumTimeout);
                }
                if (this.minimumTimeout > 0L) continue;
                break;
            }
            if (!tasks.isEmpty()) {
                long latency = System.nanoTime() - this.lastProcessingTimestamp;
                this.minimumTimeout -= latency <= 0L ? 0L : latency;
                this.minimumTimeout = this.minimumTimeout < 0L ? 0L : this.minimumTimeout;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void preTick() {
        this.lock.lock();
        try {
            if (!this.stateChanged.get()) {
                this.condition.await(this.minimumTimeout, TimeUnit.NANOSECONDS);
            }
            this.stateChanged.set(false);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IllegalMonitorStateException e) {
            SpongeImpl.getLogger().error("The scheduler internal state machine suffered a catastrophic error", (Throwable)e);
        }
    }

    @Override
    protected void postTick() {
        this.lastProcessingTimestamp = System.nanoTime();
    }

    @Override
    protected void finallyPostTick() {
        this.lock.unlock();
    }

    @Override
    protected void executeTaskRunnable(ScheduledTask task, Runnable runnable) {
        this.executor.submit(runnable);
    }

    @Override
    protected void addTask(ScheduledTask task) {
        this.lock.lock();
        try {
            super.addTask(task);
            this.stateChanged.set(true);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void onTaskCompletion(ScheduledTask task) {
        if (task.getState() == ScheduledTask.ScheduledTaskState.RUNNING) {
            this.lock.lock();
            try {
                this.stateChanged.set(true);
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

