/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.omlib.api.block.IHasItemBlock;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.api.render.camo.RenderBlockStateContainer;
import omtteam.omlib.blocks.BlockAbstractCamoTileEntity;
import omtteam.omlib.compatibility.theoneprobe.TOPCompatibility;
import omtteam.omlib.compatibility.theoneprobe.TOPInfoProvider;
import omtteam.omlib.util.EnumMachineMode;
import omtteam.omlib.util.GeneralUtil;
import omtteam.omlib.util.WorldUtil;
import omtteam.omlib.util.player.Player;
import omtteam.omlib.util.player.PlayerUtil;
import omtteam.openmodularturrets.OpenModularTurrets;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.init.ModBlocks;
import omtteam.openmodularturrets.items.UsableMetaItem;
import omtteam.openmodularturrets.items.blocks.ItemBlockTurretBase;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class BlockTurretBase
extends BlockAbstractCamoTileEntity
implements IHasItemBlock,
TOPInfoProvider {
    public static final PropertyInteger TIER = PropertyInteger.func_177719_a((String)"tier", (int)1, (int)5);
    public static final PropertyInteger LIGHT_VALUE = PropertyInteger.func_177719_a((String)"light_value", (int)0, (int)15);
    public static final PropertyInteger LIGHT_OPACITY = PropertyInteger.func_177719_a((String)"light_opacity", (int)0, (int)15);

    public BlockTurretBase() {
        super(Material.field_151576_e);
        this.func_149647_a(OpenModularTurrets.modularTurretsTab);
        if (!OMTConfig.BASES.baseBreakable) {
            this.func_149722_s();
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TIER, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)LIGHT_VALUE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)LIGHT_OPACITY, (Comparable)Integer.valueOf(0)));
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("turret_base");
        this.setRegistryName("openmodularturrets", "turret_base");
    }

    public ItemBlock getItemBlock(Block block) {
        return new ItemBlockTurretBase(block);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((Integer)state.func_177229_b((IProperty)TIER) - 1) {
            case 0: {
                int MaxCharge = OMTConfig.BASES.baseTierOne.baseMaxCharge;
                int MaxIO = OMTConfig.BASES.baseTierOne.baseMaxIo;
                return new TurretBase(MaxCharge, MaxIO, 1, state);
            }
            case 1: {
                int MaxCharge = OMTConfig.BASES.baseTierTwo.baseMaxCharge;
                int MaxIO = OMTConfig.BASES.baseTierTwo.baseMaxIo;
                return new TurretBase(MaxCharge, MaxIO, 2, state);
            }
            case 2: {
                int MaxCharge = OMTConfig.BASES.baseTierThree.baseMaxCharge;
                int MaxIO = OMTConfig.BASES.baseTierThree.baseMaxIo;
                return new TurretBase(MaxCharge, MaxIO, 3, state);
            }
            case 3: {
                int MaxCharge = OMTConfig.BASES.baseTierFour.baseMaxCharge;
                int MaxIO = OMTConfig.BASES.baseTierFour.baseMaxIo;
                return new TurretBase(MaxCharge, MaxIO, 4, state);
            }
            case 4: {
                int MaxCharge = OMTConfig.BASES.baseTierFive.baseMaxCharge;
                int MaxIO = OMTConfig.BASES.baseTierFive.baseMaxIo;
                return new TurretBase(MaxCharge, MaxIO, 5, state);
            }
        }
        return new TurretBase(1, 1, 1, state);
    }

    @ParametersAreNonnullByDefault
    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TIER, (Comparable)Integer.valueOf(meta + 1));
    }

    @ParametersAreNonnullByDefault
    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TIER) - 1;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{TIER, LIGHT_VALUE, LIGHT_OPACITY}, new IUnlistedProperty[]{RENDERBLOCKSTATE});
    }

    @ParametersAreNonnullByDefault
    public boolean func_149751_l(IBlockState state) {
        if (state instanceof IExtendedBlockState && state.func_177230_c() instanceof BlockTurretBase && ((IExtendedBlockState)state).getValue(RENDERBLOCKSTATE) != null) {
            return ((RenderBlockStateContainer)((IExtendedBlockState)state).getValue(RENDERBLOCKSTATE)).getRenderState().func_185895_e();
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() instanceof BlockTurretBase) {
            return (Integer)state.func_185899_b(world, pos).func_177229_b((IProperty)LIGHT_VALUE);
        }
        return super.getLightValue(state, world, pos);
    }

    @ParametersAreNonnullByDefault
    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() instanceof BlockTurretBase) {
            return (Integer)state.func_185899_b(world, pos).func_177229_b((IProperty)LIGHT_OPACITY);
        }
        return super.getLightValue(state, world, pos);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TurretBase base;
        if (state.func_177230_c() instanceof BlockTurretBase && worldIn.func_175625_s(pos) instanceof TurretBase && (base = (TurretBase)worldIn.func_175625_s(pos)) != null) {
            int lightValue = base.getCamoSettings().getLightValue();
            int lightOpacity = base.getCamoSettings().getLightOpacity();
            return state.func_177226_a((IProperty)LIGHT_VALUE, (Comparable)Integer.valueOf(lightValue)).func_177226_a((IProperty)LIGHT_OPACITY, (Comparable)Integer.valueOf(lightOpacity));
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    @ParametersAreNonnullByDefault
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && hand == EnumHand.MAIN_HAND) {
            TurretBase base = (TurretBase)world.func_175625_s(pos);
            if (OMTConfig.BASES.allowBaseCamo && this.handleCamoActivation(world, pos, state, player, hand, side, hitX, hitY, hitZ).isSuccess()) {
                return true;
            }
            if (player.func_70093_af() && base != null && player.func_184614_ca() != ItemStack.field_190927_a && player.func_184614_ca().func_77973_b() instanceof UsableMetaItem && player.func_184614_ca().func_77952_i() == 2) {
                ((UsableMetaItem)player.func_184614_ca().func_77973_b()).setDataStored(player.func_184614_ca(), base.writeMemoryCardNBT());
                return true;
            }
            if (!player.func_70093_af() && base != null && PlayerUtil.isPlayerAdmin((EntityPlayer)player, (IHasOwner)base) && player.func_184614_ca() != ItemStack.field_190927_a && player.func_184614_ca().func_77973_b() instanceof UsableMetaItem && player.func_184614_ca().func_77952_i() == 2 && ((UsableMetaItem)player.func_184614_ca().func_77973_b()).hasDataStored(player.func_184614_ca())) {
                base.readMemoryCardNBT(((UsableMetaItem)player.func_184614_ca().func_77973_b()).getDataStored(player.func_184614_ca()));
                base.sendMessageToAllTracking();
                base.updateCamoSettingsToPlayers();
                return true;
            }
            if (!player.func_70093_af() && base != null) {
                if (PlayerUtil.canPlayerAccessBlock((EntityPlayer)player, (IHasOwner)base)) {
                    world.func_184138_a(pos, state, state, 6);
                    player.openGui((Object)OpenModularTurrets.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                } else {
                    PlayerUtil.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentTranslation("status.ownership", new Object[0]));
                }
            }
        }
        return true;
    }

    @ParametersAreNonnullByDefault
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos neighbor) {
        if (!worldIn.field_72995_K) {
            TurretBase base = (TurretBase)worldIn.func_175625_s(pos);
            if (base != null && worldIn.func_175687_A(pos) > 0) {
                base.setRedstone(true);
            } else if (base != null && worldIn.func_175687_A(pos) == 0) {
                base.setRedstone(false);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (worldIn.func_175625_s(pos) instanceof TurretBase) {
            EntityPlayer player = (EntityPlayer)placer;
            TurretBase base = (TurretBase)worldIn.func_175625_s(pos);
            if (base == null) {
                return;
            }
            base.setCamoState(state);
            base.setOwner(new Player(player));
            if (worldIn.func_175687_A(pos) > 0) {
                base.setRedstone(true);
            } else if (worldIn.func_175687_A(pos) == 0) {
                base.setRedstone(false);
            }
            base.func_70296_d();
            switch ((Integer)state.func_177229_b((IProperty)TIER)) {
                case 1: {
                    this.func_149752_b(OMTConfig.BASES.baseTierOne.baseBlastResistance);
                    this.func_149711_c(OMTConfig.BASES.baseTierOne.baseHardness);
                    break;
                }
                case 2: {
                    this.func_149752_b(OMTConfig.BASES.baseTierTwo.baseBlastResistance);
                    this.func_149711_c(OMTConfig.BASES.baseTierTwo.baseHardness);
                    break;
                }
                case 3: {
                    this.func_149752_b(OMTConfig.BASES.baseTierThree.baseBlastResistance);
                    this.func_149711_c(OMTConfig.BASES.baseTierThree.baseHardness);
                    break;
                }
                case 4: {
                    this.func_149752_b(OMTConfig.BASES.baseTierFour.baseBlastResistance);
                    this.func_149711_c(OMTConfig.BASES.baseTierFour.baseHardness);
                    break;
                }
                case 5: {
                    this.func_149752_b(OMTConfig.BASES.baseTierFive.baseBlastResistance);
                    this.func_149711_c(OMTConfig.BASES.baseTierFive.baseHardness);
                }
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            for (TileEntity tileEntity : WorldUtil.getTouchingTileEntities((World)worldIn, (BlockPos)pos.func_177972_a(facing))) {
                if (tileEntity instanceof TurretBase) {
                    return false;
                }
                if (!(worldIn.func_175625_s(pos.func_177972_a(facing)) instanceof TurretBase)) continue;
                return false;
            }
        }
        return true;
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            this.dropItems(worldIn, pos);
            worldIn.func_175713_t(pos);
        }
    }

    @ParametersAreNonnullByDefault
    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (OMTConfig.BASES.baseBreakable) {
            switch ((Integer)blockState.func_177229_b((IProperty)TIER)) {
                case 1: {
                    return OMTConfig.BASES.baseTierOne.baseHardness;
                }
                case 2: {
                    return OMTConfig.BASES.baseTierTwo.baseHardness;
                }
                case 3: {
                    return OMTConfig.BASES.baseTierThree.baseHardness;
                }
                case 4: {
                    return OMTConfig.BASES.baseTierFour.baseHardness;
                }
                case 5: {
                    return OMTConfig.BASES.baseTierFive.baseHardness;
                }
            }
            return 10.0f;
        }
        return -1.0f;
    }

    @ParametersAreNonnullByDefault
    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (OMTConfig.BASES.baseBreakable) {
            switch ((Integer)world.func_180495_p(pos).func_177229_b((IProperty)TIER)) {
                case 1: {
                    return OMTConfig.BASES.baseTierOne.baseBlastResistance;
                }
                case 2: {
                    return OMTConfig.BASES.baseTierTwo.baseBlastResistance;
                }
                case 3: {
                    return OMTConfig.BASES.baseTierThree.baseBlastResistance;
                }
                case 4: {
                    return OMTConfig.BASES.baseTierFour.baseBlastResistance;
                }
                case 5: {
                    return OMTConfig.BASES.baseTierFive.baseBlastResistance;
                }
            }
            return 10.0f;
        }
        return -1.0f;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(0, new ItemStack(ModBlocks.turretBase, 1, this.func_176201_c(state)));
        return drops;
    }

    @ParametersAreNonnullByDefault
    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TIER) - 1;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ModBlocks.turretBase, 1, (Integer)state.func_177229_b((IProperty)TIER) - 1);
    }

    @SideOnly(value=Side.CLIENT)
    @ParametersAreNonnullByDefault
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> subItems) {
        for (int i = 0; i < 5; ++i) {
            subItems.add((Object)new ItemStack(ModBlocks.turretBase, 1, i));
        }
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TurretBase) {
            TurretBase base = (TurretBase)te;
            EnumMachineMode machineMode = base.getMode();
            boolean active = base.isActive();
            probeInfo.text("\u00a76" + TOPCompatibility.getLocalizationString((String)"gui.omtteam.omlib:mode") + ": \u00a7A" + TOPCompatibility.getLocalizationString((String)GeneralUtil.getMachineModeUnlocalization((EnumMachineMode)machineMode)), probeInfo.defaultTextStyle());
            probeInfo.text("\u00a76" + TOPCompatibility.getLocalizationString((String)"gui.omtteam.omlib:active") + ": " + GeneralUtil.getColoredBooleanColor((boolean)active) + TOPCompatibility.getLocalizationString((String)GeneralUtil.getBooleanUnlocalizationYesNo((boolean)active)), probeInfo.defaultTextStyle());
            String ownerName = base.getOwner().getName();
            probeInfo.text("\u00a76" + TOPCompatibility.getLocalizationString((String)"gui.omtteam.omlib:owner") + ": \u00a7F" + ownerName, probeInfo.defaultTextStyle());
        }
    }
}

