/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.tileentity.turrets;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.handler.OMConfig;
import omtteam.omlib.tileentity.TileEntityBase;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.player.PlayerUtil;
import omtteam.openmodularturrets.api.ITurretBaseAddonTileEntity;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.compatibility.ModCompatibility;
import omtteam.openmodularturrets.handler.config.OMTConfig;
import omtteam.openmodularturrets.init.ModSounds;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.util.TurretHeadUtil;
import omtteam.openmodularturrets.util.TurretType;
import valkyrienwarfare.api.IPhysicsEntity;
import valkyrienwarfare.api.IPhysicsEntityManager;
import valkyrienwarfare.api.TransformType;

public abstract class TurretHead
extends TileEntityBase
implements ITickable,
ITurretBaseAddonTileEntity {
    public float baseFitRotationX;
    public float baseFitRotationZ;
    public Entity target = null;
    public float rotationAnimation = 0.0f;
    public boolean shouldConceal = false;
    protected TurretBase base;
    protected int ticks;
    protected int targetingTicks;
    protected int turretTier;
    protected boolean hasSetSide = false;
    private EnumFacing turretBase;
    protected boolean playedDeploy = false;
    protected boolean autoFire = false;
    protected int ticksWithoutTarget;
    protected double targetLastX = 0.0;
    protected double targetLastY = 0.0;
    protected double targetLastZ = 0.0;
    protected double targetSpeedX = 0.0;
    protected double targetSpeedY = 0.0;
    protected double targetSpeedZ = 0.0;

    public TurretHead(int turretTier) {
        this.turretTier = turretTier;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_189515_b(var1);
        return new SPacketUpdateTileEntity(this.field_174879_c, 2, var1);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound var1 = pkt.func_148857_g();
        this.func_145839_a(var1);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("ticksBeforeFire", this.ticks);
        nbtTagCompound.func_74757_a("shouldConceal", this.shouldConceal);
        nbtTagCompound.func_74757_a("autoFire", this.autoFire);
        return nbtTagCompound;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.ticks = nbtTagCompound.func_74762_e("ticksBeforeFire");
        this.shouldConceal = nbtTagCompound.func_74767_n("shouldConceal");
        this.autoFire = nbtTagCompound.func_74767_n("autoFire");
    }

    @Nonnull
    public TileEntityOwnedBlock getLinkedBlock() {
        return this.base;
    }

    boolean setSide() {
        if (this.hasSetSide && !this.func_145831_w().func_175667_e(this.func_174877_v().func_177972_a(this.turretBase))) {
            return false;
        }
        if (this.hasSetSide) {
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177974_f()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177974_f()) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 1.565f;
            this.turretBase = EnumFacing.EAST;
            this.base = (TurretBase)this.func_145831_w().func_175625_s(this.field_174879_c.func_177974_f());
            this.hasSetSide = true;
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177976_e()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177976_e()) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 4.705f;
            this.turretBase = EnumFacing.WEST;
            this.base = (TurretBase)this.func_145831_w().func_175625_s(this.field_174879_c.func_177976_e());
            this.hasSetSide = true;
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177968_d()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177968_d()) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 3.145f;
            this.turretBase = EnumFacing.SOUTH;
            this.base = (TurretBase)this.func_145831_w().func_175625_s(this.field_174879_c.func_177968_d());
            this.hasSetSide = true;
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177978_c()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177978_c()) instanceof TurretBase) {
            this.baseFitRotationX = 1.56f;
            this.baseFitRotationZ = 0.0f;
            this.turretBase = EnumFacing.NORTH;
            this.base = (TurretBase)this.func_145831_w().func_175625_s(this.field_174879_c.func_177978_c());
            this.hasSetSide = true;
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177984_a()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177984_a()) instanceof TurretBase) {
            this.baseFitRotationX = 3.145f;
            this.baseFitRotationZ = 0.0f;
            this.turretBase = EnumFacing.UP;
            this.base = (TurretBase)this.func_145831_w().func_175625_s(this.field_174879_c.func_177984_a());
            this.hasSetSide = true;
            return true;
        }
        if (this.func_145831_w().func_175667_e(this.field_174879_c.func_177977_b()) && this.func_145831_w().func_175625_s(this.field_174879_c.func_177977_b()) instanceof TurretBase) {
            this.baseFitRotationX = 0.0f;
            this.baseFitRotationZ = 0.0f;
            this.turretBase = EnumFacing.DOWN;
            this.base = (TurretBase)this.func_145831_w().func_175625_s(this.field_174879_c.func_177977_b());
            this.hasSetSide = true;
            return true;
        }
        return false;
    }

    Entity getTargetWithMinRange() {
        return TurretHeadUtil.getTargetWithMinimumRange(this.base, this.func_145831_w(), this.field_174879_c, Math.min(this.getTurretBaseRange() + TurretHeadUtil.getRangeUpgrades(this.base, this), this.base.getCurrentMaxRange()), this);
    }

    Entity getTargetWithoutEffect() {
        return TurretHeadUtil.getTargetWithoutSlowEffect(this.base, this.func_145831_w(), this.field_174879_c, Math.min(this.getTurretBaseRange() + TurretHeadUtil.getRangeUpgrades(this.base, this), this.base.getCurrentMaxRange()), this);
    }

    private Entity getTarget() {
        return TurretHeadUtil.getTarget(this.base, this.func_145831_w(), this.field_174879_c, Math.min(this.getTurretBaseRange() + TurretHeadUtil.getRangeUpgrades(this.base, this), this.base.getCurrentMaxRange()), this);
    }

    TurretBase getBaseFromWorld() {
        return TurretHeadUtil.getTurretBase((IBlockAccess)this.func_145831_w(), this.field_174879_c);
    }

    public TurretBase getBase() {
        return this.base;
    }

    public boolean getAutoFire() {
        return this.autoFire;
    }

    public void setAutoFire(boolean autoFire) {
        this.autoFire = autoFire;
    }

    public int getTurretBasePowerUsage() {
        return this.getTurretType().getSettings().powerUsage;
    }

    public int getTurretBaseFireRate() {
        return this.getTurretType().getSettings().baseFireRate;
    }

    public double getBaseTurretAccuracy() {
        return this.getTurretType().getSettings().baseAccuracyDeviation;
    }

    public int getTurretBaseRange() {
        return this.getTurretType().getSettings().baseRange;
    }

    public double getTurretDamageAmpBonus() {
        return this.getTurretType().getSettings().damageAmp;
    }

    public double getActualTurretAccuracy() {
        return 100.0 - (100.0 - this.getBaseTurretAccuracy()) * (double)(1.0f + TurretHeadUtil.getAccuraccyUpgrades(this.getBase(), this)) * (double)(1.0f - (float)TurretHeadUtil.getScattershotUpgrades(this.getBase()) / 25.0f);
    }

    protected abstract boolean requiresAmmo();

    protected abstract boolean requiresSpecificAmmo();

    public TurretType getTurretType() {
        BlockAbstractTurretHead block = (BlockAbstractTurretHead)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c();
        return block.getTurretType();
    }

    @Nullable
    public abstract ItemStack getAmmo();

    @Nonnull
    protected abstract SoundEvent getLaunchSoundEffect();

    boolean chebyshevDistance(Entity target) {
        IPhysicsEntity physicsEntity;
        Vec3d targetPos = new Vec3d(target.field_70165_t, target.field_70163_u, target.field_70161_v);
        if (ModCompatibility.ValkyrienWarfareLoaded && (physicsEntity = IPhysicsEntityManager.INSTANCE.getPhysicsEntityFromShipSpace(this.func_145831_w(), this.func_174877_v())) != null) {
            targetPos = physicsEntity.transformVector(targetPos, TransformType.GLOBAL_TO_SUBSPACE);
        }
        if (this.base == null) {
            return false;
        }
        return MathHelper.func_76132_a((double)MathHelper.func_76132_a((double)(targetPos.field_72450_a - (double)this.func_174877_v().func_177958_n()), (double)(targetPos.field_72448_b - (double)this.func_174877_v().func_177956_o())), (double)(targetPos.field_72449_c - (double)this.func_174877_v().func_177952_p())) > (double)this.base.getCurrentMaxRange();
    }

    protected int getPowerRequiredForNextShot() {
        return Math.round((float)this.getTurretBasePowerUsage() * (1.0f - TurretHeadUtil.getEfficiencyUpgrades(this.base, this)) * (float)(1 + TurretHeadUtil.getScattershotUpgrades(this.base)));
    }

    protected ItemStack getAmmoStack() {
        ItemStack ammo;
        block4: {
            ammo = ItemStack.field_190927_a;
            if (!this.requiresAmmo()) break block4;
            if (this.requiresSpecificAmmo()) {
                for (int i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
                    ammo = TurretHeadUtil.getSpecificItemStackFromBase(this.base, this.getAmmo(), this);
                    if (ammo != ItemStack.field_190927_a) continue;
                    ammo = TurretHeadUtil.getSpecificItemFromInvExpanders(this.func_145831_w(), this.getAmmo(), this.base, this);
                }
            } else {
                for (int i = 0; i <= TurretHeadUtil.getScattershotUpgrades(this.base); ++i) {
                    ammo = TurretHeadUtil.getDisposableAmmoFromBase(this.base);
                    if (ammo != ItemStack.field_190927_a) continue;
                    ammo = TurretHeadUtil.getDisposableAmmoFromInvExpander(this.func_145831_w(), this.base);
                }
            }
        }
        return ammo;
    }

    protected void targetingChecks() {
        if (this.target == null || this.target.field_70128_L || this.func_145831_w().func_73045_a(this.target.func_145782_y()) == null || ((EntityLivingBase)this.target).func_110143_aJ() <= 0.0f) {
            this.target = this.getTarget();
        }
        if (this.target != null) {
            if (this.target instanceof EntityPlayerMP) {
                EntityPlayerMP entity = (EntityPlayerMP)this.target;
                if (!this.base.isAttacksPlayers() || PlayerUtil.isPlayerOwner((EntityPlayer)entity, (IHasOwner)this.base) || entity.field_71075_bZ.field_75098_d || PlayerUtil.isPlayerTrusted((EntityPlayer)entity, (IHasOwner)this.base) || PlayerUtil.isPlayerOP((EntityPlayer)entity) && OMConfig.GENERAL.canOPAccessOwnedBlocks) {
                    this.target = null;
                    return;
                }
            }
            if (!TurretHeadUtil.canTurretSeeTarget(this, (EntityLivingBase)this.target)) {
                this.target = null;
                return;
            }
            if (this.chebyshevDistance(this.target)) {
                this.target = null;
            }
        }
    }

    void concealmentChecks() {
        if (this.base != null && this.base.shouldConcealTurrets) {
            if (!(this.shouldConceal || this.target != null && TurretHeadUtil.canTurretSeeTarget(this, (EntityLivingBase)this.target) || this.ticksWithoutTarget < 40)) {
                this.ticksWithoutTarget = 0;
                this.shouldConceal = true;
                this.playedDeploy = false;
                this.func_145831_w().func_184133_a(null, this.field_174879_c, ModSounds.turretRetractSound, SoundCategory.BLOCKS, OMTConfig.TURRETS.turretSoundVolume, new Random().nextFloat() + 0.5f);
                this.func_145831_w().func_180501_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockAbstractTurretHead.CONCEALED, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                ++this.ticksWithoutTarget;
            }
            if (this.base != null && this.target != null) {
                this.ticksWithoutTarget = 0;
                this.shouldConceal = false;
                if (!this.playedDeploy) {
                    this.func_145831_w().func_184133_a(null, this.field_174879_c, ModSounds.turretDeploySound, SoundCategory.BLOCKS, OMTConfig.TURRETS.turretSoundVolume, new Random().nextFloat() + 0.5f);
                    this.playedDeploy = true;
                    this.func_145831_w().func_180501_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockAbstractTurretHead.CONCEALED, (Comparable)Boolean.valueOf(false)), 3);
                }
            }
        } else {
            this.shouldConceal = false;
            this.func_145831_w().func_180501_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockAbstractTurretHead.CONCEALED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }
}

