/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorCovered;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorExtract;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConveyorExtractCovered
extends ConveyorExtract {
    public ItemStack cover = ItemStack.field_190927_a;
    static final AxisAlignedBB topBox = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);

    public ConveyorExtractCovered(EnumFacing conveyorDir) {
        super(conveyorDir);
    }

    @Override
    public void onEntityCollision(TileEntity tile, Entity entity, EnumFacing facing) {
        super.onEntityCollision(tile, entity, facing);
        if (entity instanceof EntityItem) {
            ((EntityItem)entity).func_174867_a(10);
        }
    }

    @Override
    public void onItemDeployed(TileEntity tile, EntityItem entity, EnumFacing facing) {
        entity.func_174867_a(10);
        ConveyorHandler.applyMagnetSupression((Entity)entity, (ConveyorHandler.IConveyorTile)tile);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, @Nullable TileEntity tile, EnumFacing facing) {
        baseModel = super.modifyQuads(baseModel, tile, facing);
        ConveyorCovered.addCoverToQuads(baseModel, tile, facing, () -> this.cover, ConveyorHandler.ConveyorDirection.HORIZONTAL, new boolean[]{tile == null || this.renderWall(tile, facing, 0), tile == null || this.renderWall(tile, facing, 1)});
        return baseModel;
    }

    @Override
    public String getModelCacheKey(TileEntity tile, EnumFacing facing) {
        String key = super.getModelCacheKey(tile, facing);
        if (!this.cover.func_190926_b()) {
            key = key + "s" + this.cover.func_77973_b().getRegistryName() + this.cover.func_77960_j();
        }
        return key;
    }

    @Override
    public boolean playerInteraction(TileEntity tile, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, EnumFacing side) {
        if (super.playerInteraction(tile, player, hand, heldItem, hitX, hitY, hitZ, side)) {
            return true;
        }
        return ConveyorCovered.handleCoverInteraction(tile, player, hand, heldItem, () -> this.cover, itemStack -> {
            this.cover = itemStack;
        });
    }

    @Override
    public List<AxisAlignedBB> getColisionBoxes(TileEntity tile, EnumFacing facing) {
        ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{conveyorBounds});
        list.add(topBox);
        return list;
    }

    @Override
    public List<AxisAlignedBB> getSelectionBoxes(TileEntity tile, EnumFacing facing) {
        return Lists.newArrayList((Object[])new AxisAlignedBB[]{Block.field_185505_j});
    }

    @Override
    public NBTTagCompound writeConveyorNBT() {
        NBTTagCompound nbt = super.writeConveyorNBT();
        if (this.cover != null) {
            nbt.func_74782_a("cover", (NBTBase)this.cover.func_77955_b(new NBTTagCompound()));
        }
        return nbt;
    }

    @Override
    public void readConveyorNBT(NBTTagCompound nbt) {
        super.readConveyorNBT(nbt);
        this.cover = new ItemStack(nbt.func_74775_l("cover"));
    }
}

