/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import openmods.api.IValueReceiver;
import openmods.gui.IComponentParent;
import openmods.gui.component.BaseComponent;
import org.lwjgl.opengl.GL11;

public class GuiComponentLabel
extends BaseComponent
implements IValueReceiver<String> {
    private String text;
    private float scale = 1.0f;
    private List<String> formattedText;
    private int maxHeight;
    private int maxWidth;
    private int additionalLineHeight = 0;
    private List<String> tooltip;

    public GuiComponentLabel(int x, int y, String text) {
        this(x, y, -1, -1, text);
    }

    public GuiComponentLabel(int x, int y, int width, int height, String text) {
        super(x, y);
        this.text = text;
        this.maxHeight = height;
        this.maxWidth = width;
    }

    @Override
    public void init(IComponentParent parent) {
        super.init(parent);
        if (this.maxHeight < 0) {
            this.maxHeight = parent.getFontRenderer().field_78288_b;
        }
        if (this.maxWidth < 0) {
            this.maxWidth = parent.getFontRenderer().func_78256_a(this.text);
        }
    }

    public List<String> getFormattedText(FontRenderer fr) {
        if (this.formattedText == null) {
            this.formattedText = Strings.isNullOrEmpty((String)this.text) ? ImmutableList.of() : ImmutableList.copyOf((Collection)fr.func_78271_c(this.text, this.getMaxWidth()));
        }
        return this.formattedText;
    }

    @Override
    public void render(int offsetX, int offsetY, int mouseX, int mouseY) {
        FontRenderer fontRenderer = this.parent.getFontRenderer();
        if (this.getMaxHeight() < fontRenderer.field_78288_b) {
            return;
        }
        if (this.getMaxWidth() < fontRenderer.func_78263_a('m')) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offsetX + this.x), (double)(offsetY + this.y), (double)1.0);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)1.0f);
        int offset = 0;
        int lineCount = 0;
        for (String s : this.getFormattedText(fontRenderer)) {
            if (s == null) break;
            fontRenderer.func_78276_b(s, 0, offset, 0x404040);
            offset += this.getFontHeight();
            if (++lineCount < this.getMaxLines()) continue;
            break;
        }
        GL11.glPopMatrix();
    }

    @Override
    public void renderOverlay(int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.tooltip != null && !this.tooltip.isEmpty() && this.isMouseOver(mouseX, mouseY)) {
            this.drawHoveringText(this.tooltip, offsetX + mouseX, offsetY + mouseY);
        }
    }

    private int calculateHeight() {
        FontRenderer fr = this.parent.getFontRenderer();
        int offset = 0;
        int lineCount = 0;
        for (String s : this.getFormattedText(fr)) {
            if (s == null) break;
            offset += this.getFontHeight();
            if (++lineCount < this.getMaxLines()) continue;
            break;
        }
        return offset;
    }

    private int calculateWidth() {
        FontRenderer fr = this.parent.getFontRenderer();
        int maxWidth = 0;
        for (String s : this.getFormattedText(fr)) {
            if (s == null) break;
            int width = fr.func_78256_a(s);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return (int)((float)maxWidth * this.scale);
    }

    public GuiComponentLabel setScale(float scale) {
        this.formattedText = null;
        this.scale = scale;
        return this;
    }

    public float getScale() {
        return this.scale;
    }

    public GuiComponentLabel setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public void setAdditionalLineHeight(int lh) {
        this.additionalLineHeight = lh;
    }

    public int getFontHeight() {
        return this.parent.getFontRenderer().field_78288_b + this.additionalLineHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public GuiComponentLabel setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public int getMaxLines() {
        return (int)Math.floor((float)this.getMaxHeight() / this.scale / (float)this.getFontHeight());
    }

    public int getMaxWidth() {
        return (int)((float)this.maxWidth / this.scale);
    }

    @Override
    public int getHeight() {
        return (int)((double)Math.min(this.getMaxHeight(), this.calculateHeight()) + 0.5);
    }

    @Override
    public int getWidth() {
        return (int)((double)Math.min(this.getMaxWidth(), this.calculateWidth()) + 0.5);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.formattedText = null;
        this.text = Strings.nullToEmpty((String)text);
    }

    public boolean isOverflowing() {
        FontRenderer fr = this.parent.getFontRenderer();
        return this.getFormattedText(fr).size() > this.getMaxLines();
    }

    public void setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
    }

    public void clearTooltip() {
        this.tooltip = null;
    }

    @Override
    public void setValue(String value) {
        this.setText(value);
    }
}

