/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import openmods.shapes.IShapeable;
import openmods.utils.Coord;
import openmods.utils.MathUtils;

public class GeometryUtils {
    public static void makeLine(int startX, int startY, int startZ, Axis axis, int length, IShapeable shapeable) {
        GeometryUtils.makeLine(startX, startY, startZ, axis.positive, length, shapeable);
    }

    public static void makeLine(int startX, int startY, int startZ, EnumFacing direction, int length, IShapeable shapeable) {
        if (length < 0) {
            return;
        }
        Vec3i v = direction.func_176730_m();
        for (int offset = 0; offset <= length; ++offset) {
            shapeable.setBlock(startX + offset * v.func_177958_n(), startY + offset * v.func_177956_o(), startZ + offset * v.func_177952_p());
        }
    }

    public static void makePlane(int startX, int startY, int startZ, int width, int height, Axis right, Axis up, IShapeable shapeable) {
        GeometryUtils.makePlane(startX, startY, startZ, width, height, right.positive, up.positive, shapeable);
    }

    public static void makePlane(int startX, int startY, int startZ, int width, int height, EnumFacing right, EnumFacing up, IShapeable shapeable) {
        if (width < 0 || height < 0) {
            return;
        }
        Vec3i v = up.func_176730_m();
        for (int h = 0; h <= height; ++h) {
            int lineOffsetX = startX + h * v.func_177958_n();
            int lineOffsetY = startY + h * v.func_177956_o();
            int lineOffsetZ = startZ + h * v.func_177952_p();
            GeometryUtils.makeLine(lineOffsetX, lineOffsetY, lineOffsetZ, right, width, shapeable);
        }
    }

    @Deprecated
    public static void makeSphere(int radiusX, int radiusY, int radiusZ, IShapeable shapeable, EnumSet<Octant> octants) {
        GeometryUtils.makeEllipsoid(radiusX, radiusY, radiusZ, shapeable, octants);
    }

    public static void makeEllipsoid(int radiusX, int radiusY, int radiusZ, IShapeable shapeable, Set<Octant> octants) {
        ImmutableList octantsList = ImmutableList.copyOf(octants);
        double invRadiusX = 1.0 / ((double)radiusX + 0.5);
        double invRadiusY = 1.0 / ((double)radiusY + 0.5);
        double invRadiusZ = 1.0 / ((double)radiusZ + 0.5);
        double nextXn = 0.0;
        block0: for (int x = 0; x <= radiusX; ++x) {
            double xn = nextXn;
            nextXn += invRadiusX;
            double nextYn = 0.0;
            block1: for (int y = 0; y <= radiusY; ++y) {
                double yn = nextYn;
                nextYn += invRadiusY;
                double nextZn = 0.0;
                for (int z = 0; z <= radiusZ; ++z) {
                    double zn = nextZn;
                    nextZn += invRadiusZ;
                    double distanceSq = MathUtils.lengthSq(xn, yn, zn);
                    if (distanceSq > 1.0) {
                        if (z != 0) continue block1;
                        if (y != 0) continue block0;
                        break block0;
                    }
                    if (MathUtils.lengthSq(nextXn, yn, zn) <= 1.0 && MathUtils.lengthSq(xn, nextYn, zn) <= 1.0 && MathUtils.lengthSq(xn, yn, nextZn) <= 1.0) continue;
                    for (Octant octant : octantsList) {
                        shapeable.setBlock(x * octant.x, y * octant.y, z * octant.z);
                    }
                }
            }
        }
    }

    public static void makeEllipsoid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, IShapeable shapeable, Set<Octant> octants) {
        int radiusZ;
        int radiusY;
        int radiusX;
        int centerX = (minX + maxX) / 2;
        int centerY = (minY + maxY) / 2;
        int centerZ = (minZ + maxZ) / 2;
        IShapeable prevShapeable = shapeable;
        shapeable = (x, y, z) -> prevShapeable.setBlock(centerX + x, centerY + y, centerZ + z);
        int diffX = maxX - minX;
        if ((diffX & 1) == 0) {
            radiusX = diffX / 2;
        } else {
            radiusX = diffX / 2 + 1;
            shapeable = GeometryUtils.skipMiddleX(shapeable);
        }
        int diffY = maxY - minY;
        if ((diffY & 1) == 0) {
            radiusY = diffY / 2;
        } else {
            radiusY = diffY / 2 + 1;
            shapeable = GeometryUtils.skipMiddleY(shapeable);
        }
        int diffZ = maxZ - minZ;
        if ((diffZ & 1) == 0) {
            radiusZ = diffZ / 2;
        } else {
            radiusZ = diffZ / 2 + 1;
            shapeable = GeometryUtils.skipMiddleZ(shapeable);
        }
        GeometryUtils.makeEllipsoid(radiusX, radiusY, radiusZ, shapeable, octants);
    }

    public static void makeEllipse(int radiusX, int radiusZ, int y, IShapeable shapeable, Set<Quadrant> quadrants) {
        double invRadiusX = 1.0 / ((double)radiusX + 0.5);
        double invRadiusZ = 1.0 / ((double)radiusZ + 0.5);
        ImmutableList quadrantsList = ImmutableList.copyOf(quadrants);
        double nextXn = 0.0;
        block0: for (int x = 0; x <= radiusX; ++x) {
            double xn = nextXn;
            nextXn += invRadiusX;
            double nextZn = 0.0;
            for (int z = 0; z <= radiusZ; ++z) {
                double zn = nextZn;
                nextZn += invRadiusZ;
                double distanceSq = MathUtils.lengthSq(xn, zn);
                if (distanceSq > 1.0) {
                    if (z != 0) continue block0;
                    break block0;
                }
                if (MathUtils.lengthSq(nextXn, zn) <= 1.0 && MathUtils.lengthSq(xn, nextZn) <= 1.0) continue;
                for (Quadrant quadrant : quadrantsList) {
                    shapeable.setBlock(x * quadrant.x, y, z * quadrant.z);
                }
            }
        }
    }

    public static void makeEllipse(int minX, int minZ, int maxX, int maxZ, int y, IShapeable shapeable, Set<Quadrant> quadrants) {
        int radiusZ;
        int radiusX;
        int centerX = (minX + maxX) / 2;
        int centerZ = (minZ + maxZ) / 2;
        IShapeable prevShapeable = shapeable;
        shapeable = (x, y1, z) -> prevShapeable.setBlock(centerX + x, y1, centerZ + z);
        int diffX = maxX - minX;
        if ((diffX & 1) == 0) {
            radiusX = diffX / 2;
        } else {
            radiusX = diffX / 2 + 1;
            shapeable = GeometryUtils.skipMiddleX(shapeable);
        }
        int diffY = maxZ - minZ;
        if ((diffY & 1) == 0) {
            radiusZ = diffY / 2;
        } else {
            radiusZ = diffY / 2 + 1;
            shapeable = GeometryUtils.skipMiddleZ(shapeable);
        }
        GeometryUtils.makeEllipse(radiusX, radiusZ, y, shapeable, quadrants);
    }

    private static IShapeable skipMiddleX(IShapeable shapeable) {
        return (x, y, z) -> {
            if (x != 0) {
                if (x < 0) {
                    shapeable.setBlock(x + 1, y, z);
                } else {
                    shapeable.setBlock(x, y, z);
                }
            }
        };
    }

    private static IShapeable skipMiddleY(IShapeable shapeable) {
        return (x, y, z) -> {
            if (y != 0) {
                if (y < 0) {
                    shapeable.setBlock(x, y + 1, z);
                } else {
                    shapeable.setBlock(x, y, z);
                }
            }
        };
    }

    private static IShapeable skipMiddleZ(IShapeable shapeable) {
        return (x, y, z) -> {
            if (z != 0) {
                if (z < 0) {
                    shapeable.setBlock(x, y, z + 1);
                } else {
                    shapeable.setBlock(x, y, z);
                }
            }
        };
    }

    public static void line2D(int y, int x0, int z0, int x1, int z1, IShapeable shapeable) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = -Math.abs(z1 - z0);
        int sy = z0 < z1 ? 1 : -1;
        int err = dx + dy;
        while (true) {
            shapeable.setBlock(x0, y, z0);
            if (x0 == x1 && z0 == z1) break;
            int e2 = 2 * err;
            if (e2 >= dy) {
                err += dy;
                x0 += sx;
            }
            if (e2 > dx) continue;
            err += dx;
            z0 += sy;
        }
    }

    public static void line3D(Vec3d start, Vec3d end, IShapeable shapeable) {
        GeometryUtils.line3D((int)start.field_72450_a, (int)start.field_72448_b, (int)start.field_72449_c, (int)end.field_72450_a, (int)end.field_72448_b, (int)end.field_72449_c, shapeable);
    }

    public static void line3D(Coord start, Coord end, IShapeable shapeable) {
        GeometryUtils.line3D(start.x, start.y, start.z, end.x, end.y, end.z, shapeable);
    }

    public static void line3D(Vec3i start, Vec3i end, IShapeable shapeable) {
        GeometryUtils.line3D(start.func_177958_n(), start.func_177956_o(), start.func_177952_p(), end.func_177958_n(), end.func_177956_o(), end.func_177952_p(), shapeable);
    }

    public static void line3D(int startX, int startY, int startZ, int endX, int endY, int endZ, IShapeable shapeable) {
        int dx = endX - startX;
        int dy = endY - startY;
        int dz = endZ - startZ;
        int ax = Math.abs(dx) << 1;
        int ay = Math.abs(dy) << 1;
        int az = Math.abs(dz) << 1;
        int signx = Integer.signum(dx);
        int signy = Integer.signum(dy);
        int signz = Integer.signum(dz);
        int x = startX;
        int y = startY;
        int z = startZ;
        if (ax >= Math.max(ay, az)) {
            int deltay = ay - (ax >> 1);
            int deltaz = az - (ax >> 1);
            while (true) {
                shapeable.setBlock(x, y, z);
                if (x == endX) {
                    return;
                }
                if (deltay >= 0) {
                    y += signy;
                    deltay -= ax;
                }
                if (deltaz >= 0) {
                    z += signz;
                    deltaz -= ax;
                }
                x += signx;
                deltay += ay;
                deltaz += az;
            }
        }
        if (ay >= Math.max(ax, az)) {
            int deltax = ax - (ay >> 1);
            int deltaz = az - (ay >> 1);
            while (true) {
                shapeable.setBlock(x, y, z);
                if (y == endY) {
                    return;
                }
                if (deltax >= 0) {
                    x += signx;
                    deltax -= ay;
                }
                if (deltaz >= 0) {
                    z += signz;
                    deltaz -= ay;
                }
                y += signy;
                deltax += ax;
                deltaz += az;
            }
        }
        if (az >= Math.max(ax, ay)) {
            int deltax = ax - (az >> 1);
            int deltay = ay - (az >> 1);
            while (true) {
                shapeable.setBlock(x, y, z);
                if (z == endZ) {
                    return;
                }
                if (deltax >= 0) {
                    x += signx;
                    deltax -= az;
                }
                if (deltay >= 0) {
                    y += signy;
                    deltay -= az;
                }
                z += signz;
                deltax += ax;
                deltay += ay;
            }
        }
    }

    public static double normalizeAngle(double angle) {
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    public static double compareAngles(double current, double target) {
        current = GeometryUtils.normalizeAngle(current);
        target = GeometryUtils.normalizeAngle(target);
        return Math.signum(target - current);
    }

    public static double getAngleDistance(double current, double target) {
        double result = target - current;
        return Math.abs(result) > 180.0 ? 180.0 - result : result;
    }

    public static enum Quadrant {
        TopSouthWest(-1, 1),
        TopNorthEast(1, -1),
        TopNorthWest(-1, -1),
        TopSouthEast(1, 1);

        public static final EnumSet<Quadrant> ALL;
        public final int x;
        public final int z;

        private Quadrant(int x, int z) {
            this.x = x;
            this.z = z;
        }

        static {
            ALL = EnumSet.allOf(Quadrant.class);
        }
    }

    public static enum Octant {
        TopSouthWest("Top South West", EnumFacing.WEST, EnumFacing.UP, EnumFacing.SOUTH),
        TopNorthEast("Top North East", EnumFacing.EAST, EnumFacing.UP, EnumFacing.NORTH),
        TopNorthWest("Top North West", EnumFacing.WEST, EnumFacing.UP, EnumFacing.NORTH),
        TopSouthEast("Top South East", EnumFacing.EAST, EnumFacing.UP, EnumFacing.SOUTH),
        BottomSouthWest("Bottom South West", EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.SOUTH),
        BottomNorthEast("Bottom North East", EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.NORTH),
        BottomNorthWest("Bottom North West", EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.NORTH),
        BottomSouthEast("Bottom South East", EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.SOUTH);

        public static final EnumSet<Octant> ALL;
        public static final EnumSet<Octant> TOP;
        public static final EnumSet<Octant> BOTTOM;
        public static final EnumSet<Octant> NORTH;
        public static final EnumSet<Octant> SOUTH;
        public static final EnumSet<Octant> EAST;
        public static final EnumSet<Octant> WEST;
        public final EnumSet<EnumFacing> dirs;
        public final int x;
        public final int y;
        public final int z;
        public final String name;

        public int getXOffset() {
            return this.x;
        }

        public int getYOffset() {
            return this.y;
        }

        public int getZOffset() {
            return this.z;
        }

        public String getFriendlyName() {
            return this.name;
        }

        private Octant(String friendlyName, EnumFacing dirX, EnumFacing dirY, EnumFacing dirZ) {
            this.x = dirX.func_82601_c() + dirY.func_82601_c() + dirZ.func_82601_c();
            this.y = dirX.func_96559_d() + dirY.func_96559_d() + dirZ.func_96559_d();
            this.z = dirX.func_82599_e() + dirY.func_82599_e() + dirZ.func_82599_e();
            this.dirs = EnumSet.of(dirX, dirY, dirZ);
            this.name = friendlyName;
        }

        private static EnumSet<Octant> select(EnumFacing dir) {
            Set result = Sets.newIdentityHashSet();
            for (Octant o : Octant.values()) {
                if (!o.dirs.contains(dir)) continue;
                result.add(o);
            }
            return EnumSet.copyOf(result);
        }

        static {
            ALL = EnumSet.allOf(Octant.class);
            TOP = Octant.select(EnumFacing.UP);
            BOTTOM = Octant.select(EnumFacing.DOWN);
            NORTH = Octant.select(EnumFacing.NORTH);
            SOUTH = Octant.select(EnumFacing.SOUTH);
            EAST = Octant.select(EnumFacing.EAST);
            WEST = Octant.select(EnumFacing.WEST);
        }
    }

    public static enum Axis {
        X(1, 0, 0, EnumFacing.EAST, EnumFacing.WEST),
        Y(0, 1, 0, EnumFacing.UP, EnumFacing.DOWN),
        Z(0, 0, 1, EnumFacing.SOUTH, EnumFacing.NORTH);

        public final int dx;
        public final int dy;
        public final int dz;
        public final EnumFacing positive;
        public final EnumFacing negative;

        private Axis(int dx, int dy, int dz, EnumFacing positive, EnumFacing negative) {
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
            this.positive = positive;
            this.negative = negative;
        }
    }
}

