/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.network;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import reborncore.RebornCore;
import reborncore.common.network.ObjectBufferUtils;

public class ExtendedPacketBuffer
extends PacketBuffer {
    public ExtendedPacketBuffer(ByteBuf wrapped) {
        super(wrapped);
    }

    public void writeObject(Object object) {
        ObjectBufferUtils.writeObject(object, this);
    }

    public Object readObject() {
        return ObjectBufferUtils.readObject(this);
    }

    public void writeBigInt(BigInteger bigInteger) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = new ObjectOutputStream(baos);
            outputStream.writeObject(bigInteger);
            this.func_179250_a(baos.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write big int");
        }
    }

    public BigInteger readBigInt() {
        try {
            ObjectInputStream inputStream = new ObjectInputStream(new ByteArrayInputStream(this.func_179251_a()));
            return (BigInteger)inputStream.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read big int");
        }
    }

    public void writeFluidStack(FluidStack fluidStack) {
        try {
            if (fluidStack == null || FluidRegistry.getFluidName((FluidStack)fluidStack) == null) {
                this.writeShort(-1);
            } else {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                CompressedStreamTools.func_74799_a((NBTTagCompound)fluidStack.writeToNBT(new NBTTagCompound()), (OutputStream)byteStream);
                byte[] bytes = byteStream.toByteArray();
                this.writeShort((short)bytes.length);
                this.func_179250_a(bytes);
            }
        }
        catch (IOException exception) {
            RebornCore.logHelper.fatal(exception);
        }
    }

    public FluidStack readFluidStack() {
        try {
            short length = this.readShort();
            if (length < 0) {
                return null;
            }
            byte[] bytes = this.func_189425_b(length);
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)CompressedStreamTools.func_74796_a((InputStream)byteStream));
        }
        catch (IOException exception) {
            RebornCore.logHelper.fatal(exception);
            return null;
        }
    }
}

