/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.moons.io.entities;

import galaxyspace.core.GSItems;
import galaxyspace.core.prefab.entities.EntityFlyBossBase;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class EntityBossGhast
extends EntityFlyBossBase
implements IMob,
IEntityBreathable {
    protected long ticks = 0L;
    public Entity targetEntity;
    public int entitiesWithin;
    public int entitiesWithinLast;
    private Vector3 roomCoords;
    private Vector3 roomSize;
    private boolean spawnedMinion;
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityBossGhast.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityBossGhast(World par1World) {
        super(par1World);
        this.func_70105_a(4.0f, 3.0f);
        this.field_70178_ae = true;
        this.field_70765_h = new GhastMoveHelper(this);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIFireballAttack(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AILookAround(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.func_190530_aW()) {
            return false;
        }
        if ("fireball".equals(par1DamageSource.func_76355_l()) && this.func_94060_bK() instanceof EntityPlayer) {
            super.func_70097_a(par1DamageSource, 5.0f);
            return true;
        }
        if (par2 > 3.0f) {
            return super.func_70097_a(par1DamageSource, 4.0f);
        }
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0 * ConfigManagerCore.dungeonBossHealthMod);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.05f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
    }

    public EntityBossGhast(World world, Vector3 vec) {
        this(world);
        this.func_70107_b(vec.x, vec.y, vec.z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187551_bH;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187555_bJ;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187553_bI;
    }

    @Override
    protected void func_70609_aI() {
        super.func_70609_aI();
        if (!this.field_70170_p.field_72995_K && this.deathTicks == 100) {
            GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_BOSS_DEATH, GCCoreUtil.getDimensionID((World)this.field_70170_p), new Object[]{Float.valueOf(1.5f)}), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID((World)this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
        }
    }

    public boolean func_70090_H() {
        return false;
    }

    public boolean func_70072_I() {
        return false;
    }

    public void func_70653_a(Entity par1Entity, float par2, double par3, double par5) {
    }

    @Override
    public void func_70636_d() {
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 1L;
        }
        ++this.ticks;
        EntityPlayer player = this.field_70170_p.func_184137_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 20.0, false);
        if (player != null && !player.equals((Object)this.targetEntity)) {
            if (this.func_70068_e((Entity)player) < 400.0) {
                this.func_70661_as().func_75494_a((Entity)player);
                this.targetEntity = player;
            }
        } else {
            this.targetEntity = null;
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) + this.field_70146_Z.nextDouble() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)this.field_70130_N, this.field_70163_u - 2.0 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) + this.field_70146_Z.nextDouble() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)this.field_70130_N, 0.0, 0.1, 0.0, new int[0]);
            }
        }
        super.func_70636_d();
    }

    protected void func_70628_a(boolean par1, int par2) {
    }

    public EntityItem func_70099_a(ItemStack par1ItemStack, float par2) {
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)par2, this.field_70161_v, par1ItemStack);
        entityitem.field_70181_x = -2.0;
        entityitem.func_174869_p();
        if (this.captureDrops) {
            this.capturedDrops.add(entityitem);
        } else {
            this.field_70170_p.func_72838_d((Entity)entityitem);
        }
        return entityitem;
    }

    public boolean canBreath() {
        return true;
    }

    @Override
    public ItemStack getGuaranteedLoot(Random rand) {
        List stackList = GalacticraftRegistry.getDungeonLoot((int)5);
        return ((ItemStack)stackList.get(rand.nextInt(stackList.size()))).func_77946_l();
    }

    protected boolean shouldAttack(EntityLivingBase living) {
        return true;
    }

    protected void spitFireball() {
        Vec3d vec3d = this.func_70676_i(1.0f);
        double d2 = this.func_70638_az().field_70165_t - (this.field_70165_t + vec3d.field_72450_a * 4.0);
        double d3 = this.func_70638_az().func_174813_aQ().field_72338_b + (double)(this.func_70638_az().field_70131_O / 2.0f) - (0.5 + this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double d4 = this.func_70638_az().field_70161_v - (this.field_70161_v + vec3d.field_72449_c * 4.0);
        EntityLargeFireball entitylargefireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, d2, d3, d4);
        entitylargefireball.field_92057_e = 2;
        entitylargefireball.field_70165_t = this.field_70165_t + vec3d.field_72450_a * 4.0;
        entitylargefireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
        entitylargefireball.field_70161_v = this.field_70161_v + vec3d.field_72449_c * 4.0;
        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
        if (this.field_70146_Z.nextInt(6) == 0) {
            this.func_70624_b(null);
        }
    }

    @Override
    public int getChestTier() {
        return 5;
    }

    @Override
    public void dropKey() {
        this.func_70099_a(new ItemStack(GSItems.DUNGEON_KEYS, 1, 1), 0.5f);
    }

    @Override
    public BossInfo.Color getHealthBarColor() {
        return BossInfo.Color.RED;
    }

    static class GhastMoveHelper
    extends EntityMoveHelper {
        private final EntityBossGhast parentEntity;
        private int courseChangeCooldown;

        public GhastMoveHelper(EntityBossGhast ghast) {
            super((EntityLiving)ghast);
            this.parentEntity = ghast;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        this.parentEntity.field_70159_w += d0 / d3 * 0.1;
                        this.parentEntity.field_70181_x += d1 / d3 * 0.1;
                        this.parentEntity.field_70179_y += d2 / d3 * 0.1;
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public static class AIFireballAttack
    extends EntityAIBase {
        private final EntityBossGhast parentEntity;
        public int attackTimer;
        public int prevAttackTimer;

        public AIFireballAttack(EntityBossGhast ghast) {
            this.parentEntity = ghast;
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            return entitylivingbase != null;
        }

        public void func_75249_e() {
            this.prevAttackTimer = 0;
            this.attackTimer = 0;
        }

        public void func_75251_c() {
            this.parentEntity.setAttacking(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0 && this.parentEntity.func_70635_at().func_75522_a((Entity)entitylivingbase)) {
                World world = this.parentEntity.field_70170_p;
                this.prevAttackTimer = this.attackTimer++;
                this.parentEntity.func_70671_ap().func_75651_a((Entity)entitylivingbase, 10.0f, (float)this.parentEntity.func_70646_bf());
                if (this.attackTimer == 10) {
                    this.parentEntity.func_184185_a(SoundEvents.field_187559_bL, 10.0f, this.parentEntity.func_70647_i());
                }
                if (this.attackTimer == 20) {
                    if (this.parentEntity.shouldAttack(entitylivingbase)) {
                        this.parentEntity.func_184185_a(SoundEvents.field_187557_bK, 10.0f, this.parentEntity.func_70647_i());
                        this.parentEntity.spitFireball();
                        this.prevAttackTimer = this.attackTimer;
                    }
                    this.attackTimer = -40;
                }
            } else if (this.attackTimer > 0) {
                this.prevAttackTimer = this.attackTimer--;
            }
            this.parentEntity.setAttacking(this.attackTimer > 10);
        }
    }

    static class AILookAround
    extends EntityAIBase {
        private final EntityBossGhast parentEntity;

        public AILookAround(EntityBossGhast ghast) {
            this.parentEntity = ghast;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)this.parentEntity.field_70159_w, (double)this.parentEntity.field_70179_y)) * 57.295776f;
            } else {
                EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
                double d0 = 64.0;
                if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4096.0) {
                    double d1 = entitylivingbase.field_70165_t - this.parentEntity.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.parentEntity.field_70161_v;
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private final EntityBossGhast parentEntity;

        public AIRandomFly(EntityBossGhast ghast) {
            this.parentEntity = ghast;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }
}

