/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.core.GSItems;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.machines.BlockLiquidExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityLiquidExtractor
extends TileBaseElectricBlockWithInventory
implements IFluidHandlerWrapper,
ISidedInventory,
IPacketReceiver {
    private int PROCESS_TIME_REQUIRED;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks;
    private final int tankCapacity = 3000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank;
    private static HashMap<Block, FluidStack> extractfluid = new HashMap();
    private List<BlockPos> blocks;
    private int number;

    public TileEntityLiquidExtractor() {
        super("tile.liquid_extractor.name");
        this.processTimeRequired = this.PROCESS_TIME_REQUIRED = 30;
        this.processTicks = 0;
        this.tankCapacity = 3000;
        this.waterTank = new FluidTank(this.tankCapacity);
        this.blocks = new ArrayList<BlockPos>();
        this.number = 0;
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 60.0f : 45.0f);
        this.inventory = NonNullList.func_191197_a((int)7, (Object)ItemStack.field_190927_a);
        this.setTierGC(1);
        extractfluid.put(Blocks.field_150432_aD, new FluidStack(FluidRegistry.WATER, 100));
    }

    public static void addBlockAndFluid(Block block, FluidStack fluidstack) {
        extractfluid.put(block, fluidstack);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            int range = 2;
            GSUtils.checkFluidTankTransfer((NonNullList<ItemStack>)this.getInventory(), 1, this.waterTank);
            if (this.canProcess()) {
                int energy_boost = 0;
                for (int i = 0; i <= 3; ++i) {
                    if (((ItemStack)this.getInventory().get(3 + i)).func_77969_a(new ItemStack(GSItems.UPGRADES, 1, 0))) {
                        range += 2;
                    }
                    if (!((ItemStack)this.getInventory().get(3 + i)).func_77969_a(new ItemStack(GSItems.UPGRADES, 1, 3))) continue;
                    ++energy_boost;
                }
                this.storage.setMaxExtract(ConfigManagerCore.hardMode ? (float)(60 - 20 * energy_boost) : (float)(45 - 15 * energy_boost));
                this.blocks.clear();
                BlockPos pos1 = new BlockPos(this.func_174877_v().func_177958_n() - range, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - range);
                BlockPos pos2 = new BlockPos(this.func_174877_v().func_177958_n() + range, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + range);
                this.func_174877_v();
                BlockPos.func_177980_a((BlockPos)pos1, (BlockPos)pos2).forEach(block -> this.blocks.add((BlockPos)block));
                if (this.number > this.blocks.size() - 1) {
                    this.number = 0;
                }
                if (this.hasEnoughEnergyToRun) {
                    if (this.processTicks == 0) {
                        this.processTicks = this.processTimeRequired;
                    } else if (--this.processTicks <= 0) {
                        this.smeltItem(this.number++);
                        this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                    }
                } else if (this.processTicks > 0 && this.processTicks < this.processTimeRequired && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    ++this.processTicks;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    public boolean canProcess() {
        return this.waterTank.getFluidAmount() < this.waterTank.getCapacity();
    }

    public void smeltItem(int num) {
        if (this.canProcess()) {
            BlockPos pos = this.blocks.get(num).func_177977_b();
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            Block block = state.func_177230_c();
            int meta = state.func_177230_c().func_176201_c(state);
            if (meta == 0) {
                if (block == Blocks.field_150355_j) {
                    Fluid water = FluidRegistry.WATER;
                    this.waterTank.fill(new FluidStack(water, 1000), true);
                    if (this.waterTank.getFluid().isFluidEqual(new FluidStack(FluidRegistry.lookupFluidForBlock((Block)block), 0))) {
                        this.field_145850_b.func_175698_g(pos);
                    }
                    return;
                }
                if (block == Blocks.field_150353_l) {
                    this.waterTank.fill(new FluidStack(FluidRegistry.LAVA, 1000), true);
                    if (this.waterTank.getFluid().isFluidEqual(new FluidStack(FluidRegistry.lookupFluidForBlock((Block)block), 0))) {
                        this.field_145850_b.func_175698_g(pos);
                    }
                    return;
                }
                if (block instanceof BlockFluidClassic) {
                    Fluid fluid = ((BlockFluidClassic)block).getFluid();
                    this.waterTank.fill(new FluidStack(fluid, 1000), true);
                    if (this.waterTank.getFluid().isFluidEqual(new FluidStack(FluidRegistry.lookupFluidForBlock((Block)block), 0))) {
                        this.field_145850_b.func_175698_g(pos);
                    }
                    return;
                }
                if (block instanceof IFluidBlock) {
                    IFluidBlock fluid = (IFluidBlock)block;
                    this.waterTank.fill(new FluidStack(fluid.getFluid(), 1000), true);
                    if (this.waterTank.getFluid().isFluidEqual(new FluidStack(FluidRegistry.lookupFluidForBlock((Block)block), 0))) {
                        this.field_145850_b.func_175698_g(pos);
                    }
                    return;
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        ItemStackHelper.func_191283_b((NBTTagCompound)par1NBTTagCompound, (NonNullList)this.getInventory());
        this.number = par1NBTTagCompound.func_74762_e("number");
        if (par1NBTTagCompound.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        super.func_189515_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        ItemStackHelper.func_191282_a((NBTTagCompound)par1NBTTagCompound, (NonNullList)this.getInventory());
        par1NBTTagCompound.func_74768_a("number", this.number);
        if (this.waterTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
        return par1NBTTagCompound;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockLiquidExtractor) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockLiquidExtractor.FACING);
        }
        return EnumFacing.NORTH;
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.getInventory().get(var1);
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return slotID == 0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return this.processTicks > 0;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (from == this.getPipe() && resource != null && resource.isFluidEqual(this.waterTank.getFluid())) {
            return this.waterTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (from == this.getPipe()) {
            return this.waterTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (from == this.getPipe()) {
            return this.waterTank.getFluid() != null && this.waterTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    private EnumFacing getPipe() {
        return this.getFront().func_176735_f();
    }

    public EnumFacing getElectricInputDirection() {
        return this.getFront().func_176746_e();
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        if (type == NetworkType.FLUID) {
            EnumFacing pipeSide = this.getPipe();
            return direction == pipeSide;
        }
        return false;
    }

    public int getScaledTankLevel(int i) {
        return this.waterTank.getFluidAmount() * i / this.waterTank.getCapacity();
    }
}

