/*
 * Decompiled with CFR 0.152.
 */
package org.dave.ocsensors.integration.reflection;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;
import org.dave.ocsensors.integration.PrefixRegistry;
import org.dave.ocsensors.integration.reflection.ReflectionConfig;
import org.dave.ocsensors.integration.reflection.ReflectionIntegration;
import org.dave.ocsensors.utility.Logz;

public class ReflectionConfigSerializer
implements JsonDeserializer<ReflectionConfig> {
    public ReflectionConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonArray()) {
            Logz.info("Invalid reflection config! Not a json array!", new Object[0]);
            return null;
        }
        for (JsonElement entry : json.getAsJsonArray()) {
            Class<?> mappingClass;
            if (!entry.isJsonObject()) {
                Logz.info("Invalid reflection config! Skipping entry: not a JSON object!", new Object[0]);
                continue;
            }
            JsonObject teObject = entry.getAsJsonObject();
            if (!teObject.has("class")) {
                Logz.info("Invalid reflection config! Skipping TileEntity entry: missing 'class' property!", new Object[0]);
                continue;
            }
            String className = teObject.get("class").getAsString();
            try {
                mappingClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                Logz.info("Class not found: %s", className);
                continue;
            }
            String prefix = "";
            if (teObject.has("prefix")) {
                String rawPrefix = teObject.get("prefix").getAsString();
                PrefixRegistry.addSupportedPrefix(ReflectionIntegration.class, rawPrefix);
                prefix = rawPrefix + ".";
            }
            if (teObject.has("methods")) {
                for (Map.Entry rule : teObject.get("methods").getAsJsonObject().entrySet()) {
                    if (((JsonElement)rule.getValue()).isJsonObject() && ((JsonElement)rule.getValue()).getAsJsonObject().has("obf") && ((JsonElement)rule.getValue()).getAsJsonObject().has("deobf")) {
                        String obfName = ((JsonElement)rule.getValue()).getAsJsonObject().get("obf").getAsString();
                        String deobfName = ((JsonElement)rule.getValue()).getAsJsonObject().get("deobf").getAsString();
                        ReflectionIntegration.addMethodMapping(mappingClass, prefix + (String)rule.getKey(), deobfName, obfName);
                        continue;
                    }
                    if (((JsonElement)rule.getValue()).isJsonPrimitive()) {
                        String methodName = ((JsonElement)rule.getValue()).getAsString();
                        ReflectionIntegration.addMethodMapping(mappingClass, prefix + (String)rule.getKey(), methodName, methodName);
                        continue;
                    }
                    Logz.warn("Invalid method specification for class '%s' in reflection config.", className);
                }
            }
            if (!teObject.has("fields")) continue;
            for (Map.Entry rule : teObject.get("fields").getAsJsonObject().entrySet()) {
                ReflectionIntegration.addFieldMapping(mappingClass, prefix + (String)rule.getKey(), ((JsonElement)rule.getValue()).getAsString());
            }
        }
        return null;
    }
}

