/*
 * Decompiled with CFR 0.152.
 */
package org.dave.ocsensors.integration.reflection;

import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.dave.ocsensors.integration.AbstractIntegration;
import org.dave.ocsensors.integration.Integrate;
import org.dave.ocsensors.integration.PrefixRegistry;
import org.dave.ocsensors.integration.ScanDataList;
import org.dave.ocsensors.integration.reflection.ReflectionConfig;
import org.dave.ocsensors.misc.ConfigurationHandler;
import org.dave.ocsensors.utility.Logz;
import org.dave.ocsensors.utility.ObfuscationReflectionHelperEx;
import org.dave.ocsensors.utility.ResourceLoader;
import org.dave.ocsensors.utility.Serialization;

@Integrate(name="reflection")
public class ReflectionIntegration
extends AbstractIntegration {
    private static Map<Class, Map<String, IReflectionMapping>> classMappings;
    private static Set<Class> supportedClasses;

    @Override
    public void reload() {
        classMappings = new HashMap<Class, Map<String, IReflectionMapping>>();
        supportedClasses = new HashSet<Class>();
        PrefixRegistry.clearSupportedPrefixes(ReflectionIntegration.class);
        if (!ConfigurationHandler.reflectionDataDir.exists()) {
            return;
        }
        ResourceLoader loader = new ResourceLoader(ConfigurationHandler.reflectionDataDir, "assets/ocsensors/config/reflection/");
        for (Map.Entry<String, InputStream> entry : loader.getResources().entrySet()) {
            String filename = entry.getKey();
            InputStream is = entry.getValue();
            Logz.info(" > Loading reflection config from file: '%s'", filename);
            Serialization.GSON.fromJson(new JsonReader((Reader)new InputStreamReader(is)), ReflectionConfig.class);
        }
    }

    private static void initClassMapping(Class clazz) {
        if (!supportedClasses.contains(clazz)) {
            supportedClasses.add(clazz);
        }
        if (!classMappings.containsKey(clazz)) {
            classMappings.put(clazz, new HashMap());
        }
    }

    public static void addMethodMapping(Class clazz, String propertyPath, String methodName, String obfName) {
        ReflectionIntegration.initClassMapping(clazz);
        classMappings.get(clazz).put(propertyPath, new MethodMapping(clazz, methodName, obfName));
    }

    public static void addFieldMapping(Class clazz, String propertyPath, String fieldName) {
        ReflectionIntegration.initClassMapping(clazz);
        classMappings.get(clazz).put(propertyPath, new FieldMapping(clazz, fieldName));
    }

    @Override
    public boolean worksWith(TileEntity entity, @Nullable EnumFacing side) {
        return supportedClasses.stream().anyMatch(c -> c.isAssignableFrom(entity.getClass()));
    }

    @Override
    public boolean worksWith(Entity entity) {
        return supportedClasses.stream().anyMatch(c -> c.isAssignableFrom(entity.getClass()));
    }

    private void addUniversalScanData(ScanDataList data, Object entity) {
        for (Map.Entry<Class, Map<String, IReflectionMapping>> entry : classMappings.entrySet()) {
            Class clazz = entry.getKey();
            Map<String, IReflectionMapping> entriesForClazz = entry.getValue();
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            for (Map.Entry<String, IReflectionMapping> mappingEntry : entriesForClazz.entrySet()) {
                String propertyPath = mappingEntry.getKey();
                IReflectionMapping mapping = mappingEntry.getValue();
                if (!mapping.isValid()) continue;
                data.add(propertyPath, mapping.getResult(clazz, entity));
            }
        }
    }

    @Override
    public void addScanData(ScanDataList data, TileEntity entity, @Nullable EnumFacing side) {
        this.addUniversalScanData(data, entity);
    }

    @Override
    public void addScanData(ScanDataList data, Entity entity) {
        this.addUniversalScanData(data, entity);
    }

    private static class FieldMapping
    implements IReflectionMapping {
        private String fieldName;
        private Field field = null;

        public FieldMapping(Class clz, String fieldName) {
            this.fieldName = fieldName;
            this.field = ObfuscationReflectionHelperEx.findField(clz, fieldName);
        }

        @Override
        public Object getResult(Class clz, Object entity) {
            try {
                return this.field.get(entity);
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }

        @Override
        public boolean isValid() {
            return this.field != null;
        }
    }

    private static class MethodMapping
    implements IReflectionMapping {
        private String methodName;
        private Method method = null;

        public MethodMapping(Class clz, String methodName, String obfMethodName) {
            this.methodName = methodName;
            try {
                this.method = ReflectionHelper.findMethod((Class)clz, (String)methodName, (String)obfMethodName, (Class[])new Class[0]);
            }
            catch (ReflectionHelper.UnableToFindMethodException e) {
                Logz.warn("Could not find method '%s' in class '%s'! Exception=%s", new Object[]{this.methodName, clz.getName(), e});
            }
        }

        @Override
        public Object getResult(Class clz, Object entity) {
            try {
                return this.method.invoke(entity, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public boolean isValid() {
            return this.method != null;
        }
    }

    private static interface IReflectionMapping {
        public Object getResult(Class var1, Object var2);

        public boolean isValid();
    }
}

