/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.tileentity;

import gtclassic.api.interfaces.IGTDebuggableTile;
import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.recipe.RecipeModifierHelpers;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IMachine;
import ic2.api.recipe.IRecipeInput;
import ic2.core.RotationList;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.filters.MachineFilter;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.obj.IClickable;
import ic2.core.util.obj.ITankListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.Nullable;
import trinsdar.ic2c_extras.container.ContainerFluidCanningMachine;
import trinsdar.ic2c_extras.tileentity.base.TileEntityFluidCannerBase;
import trinsdar.ic2c_extras.util.FluidMachineOutput;
import trinsdar.ic2c_extras.util.GuiMachine;
import trinsdar.ic2c_extras.util.recipelists.FluidCanningRecipeList;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasLang;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasResourceLocations;

@Optional.Interface(iface="gtclassic.api.interfaces.IGTDebuggableTile", modid="gtclassic", striprefs=true)
public class TileEntityFluidCanningMachine
extends TileEntityFluidCannerBase
implements ITankListener,
IClickable,
IGTDebuggableTile,
IFluidHandler {
    public static FluidCanningRecipeList fluidCanning = new FluidCanningRecipeList("fluidCanning");
    public MachineFilter filter = new MachineFilter((IMachine)this);

    public TileEntityFluidCanningMachine() {
        super(3, 4, 1, 400, 32);
        slotInput = 0;
        slotOutput = 2;
        this.setFuelSlot(1);
        this.inputTank.addListener((ITankListener)this);
        this.outputTank.addListener((ITankListener)this);
        this.inputTank.setCanFill(true);
        this.outputTank.setCanFill(false);
        this.inputTank.setCanDrain(false);
        this.outputTank.setCanDrain(true);
        this.addGuiFields(new String[]{"inputTank", "outputTank"});
    }

    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, new int[]{1});
        handler.registerDefaultSlotAccess(AccessRule.Import, new int[]{0});
        handler.registerDefaultSlotAccess(AccessRule.Export, new int[]{2});
        handler.registerDefaultSlotsForSide(RotationList.UP.invert(), new int[]{2});
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), new int[]{0});
        handler.registerInputFilter((IFilter)new ArrayFilter(new IFilter[]{CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)}), new int[]{1});
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, new int[]{1});
        handler.registerSlotType(SlotType.Fuel, new int[]{1});
        handler.registerSlotType(SlotType.Input, new int[]{0});
        handler.registerSlotType(SlotType.Output, new int[]{2});
    }

    public void onTankChanged(IFluidTank tank) {
        this.getNetwork().updateTileGuiField((TileEntity)this, "inputTank");
        this.getNetwork().updateTileGuiField((TileEntity)this, "outputTank");
        this.shouldCheckRecipe = true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTank.readFromNBT(nbt.func_74775_l("inputTank"));
        this.outputTank.readFromNBT(nbt.func_74775_l("outputTank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.inputTank.writeToNBT(this.getTag(nbt, "inputTank"));
        this.outputTank.writeToNBT(this.getTag(nbt, "outputTank"));
        return nbt;
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{slotInput};
    }

    @Override
    public IFilter[] getInputFilters(int[] slots) {
        return new IFilter[]{this.filter};
    }

    @Override
    public boolean isRecipeSlot(int slot) {
        return true;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{slotOutput};
    }

    @Override
    public FluidCanningRecipeList getRecipeList() {
        return fluidCanning;
    }

    public Set<IMachineUpgradeItem.UpgradeType> getSupportedTypes() {
        return new LinkedHashSet<IMachineUpgradeItem.UpgradeType>(Arrays.asList(IMachineUpgradeItem.UpgradeType.values()));
    }

    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerFluidCanningMachine(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiMachine.FluidCanningGui.class;
    }

    public LocaleComp getBlockName() {
        return Ic2cExtrasLang.FLUID_CANNING_MACHINE;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public double getWrenchDropRate() {
        return 1.0;
    }

    public ResourceLocation getGuiTexture() {
        return Ic2cExtrasResourceLocations.FLUID_CANNING_MACHINE;
    }

    public static void addFillingRecipe(IRecipeInput input, FluidStack inputFluid, ItemStack output) {
        TileEntityFluidCanningMachine.addFillingRecipe(input, inputFluid, output, 50);
    }

    public static void addEmptyingRecipe(IRecipeInput input, ItemStack output, FluidStack outputFluid) {
        TileEntityFluidCanningMachine.addEmptyingRecipe(input, output, outputFluid, 50);
    }

    public static void addFillingRecipe(IRecipeInput input, FluidStack inputFluid, ItemStack output, int totalEu) {
        TileEntityFluidCanningMachine.addFillingRecipe(input, inputFluid, output, TileEntityFluidCanningMachine.totalEu(totalEu));
    }

    public static void addEmptyingRecipe(IRecipeInput input, ItemStack output, FluidStack outputFluid, int totalEu) {
        TileEntityFluidCanningMachine.addEmptyingRecipe(input, output, outputFluid, TileEntityFluidCanningMachine.totalEu(totalEu));
    }

    public static RecipeModifierHelpers.IRecipeModifier[] totalEu(int amount) {
        return new RecipeModifierHelpers.IRecipeModifier[]{RecipeModifierHelpers.ModifierType.RECIPE_LENGTH.create(amount - 400)};
    }

    public static void addFillingRecipe(IRecipeInput input, FluidStack inputFluid, ItemStack output, RecipeModifierHelpers.IRecipeModifier[] modifiers) {
        NBTTagCompound mods = new NBTTagCompound();
        for (RecipeModifierHelpers.IRecipeModifier modifier : modifiers) {
            modifier.apply(mods);
        }
        fluidCanning.addFillingRecipe(input, inputFluid, new MachineOutput(mods, new ItemStack[]{output}), "filling_" + output.func_77977_a() + "_" + inputFluid.getUnlocalizedName());
    }

    public static void addEmptyingRecipe(IRecipeInput input, ItemStack output, FluidStack outputFluid, RecipeModifierHelpers.IRecipeModifier[] modifiers) {
        NBTTagCompound mods = new NBTTagCompound();
        for (RecipeModifierHelpers.IRecipeModifier modifier : modifiers) {
            modifier.apply(mods);
        }
        fluidCanning.addEmptyingRecipe(input, new FluidMachineOutput(mods, outputFluid, output), "emptying_" + output.func_77977_a() + "_" + outputFluid.getUnlocalizedName());
    }

    public static void addEnrichingRecipe(IRecipeInput input, FluidStack inputFluid, ItemStack output, FluidStack outputFluid, RecipeModifierHelpers.IRecipeModifier[] modifiers) {
        NBTTagCompound mods = new NBTTagCompound();
        for (RecipeModifierHelpers.IRecipeModifier modifier : modifiers) {
            modifier.apply(mods);
        }
        fluidCanning.addEnrichingRecipe(input, inputFluid, new FluidMachineOutput(mods, outputFluid, output), "enriching_" + output.func_77977_a());
    }

    public static void addEnrichingRecipe(IRecipeInput input, FluidStack inputFluid, FluidStack outputFluid, RecipeModifierHelpers.IRecipeModifier[] modifiers) {
        NBTTagCompound mods = new NBTTagCompound();
        for (RecipeModifierHelpers.IRecipeModifier modifier : modifiers) {
            modifier.apply(mods);
        }
        fluidCanning.addEnrichingRecipe(input, inputFluid, outputFluid, mods, "enriching_" + outputFluid.getFluid().getUnlocalizedName());
    }

    public boolean hasRightClick() {
        return true;
    }

    public boolean onRightClick(EntityPlayer player, EnumHand hand, EnumFacing enumFacing, Side side) {
        ItemStack playerStack = player.func_184586_b(hand);
        if (!playerStack.func_190926_b()) {
            FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)playerStack, (IFluidHandler)this.inputTank, (int)(this.inputTank.getCapacity() - this.inputTank.getFluidAmount()), (EntityPlayer)player, (boolean)true);
            if (result.isSuccess()) {
                playerStack.func_190918_g(1);
                ItemStack resultStack = result.getResult();
                if (!resultStack.func_190926_b() && !player.field_71071_by.func_70441_a(resultStack)) {
                    player.func_71019_a(resultStack, false);
                }
                return true;
            }
            FluidActionResult result2 = FluidUtil.tryFillContainer((ItemStack)playerStack, (IFluidHandler)this.outputTank, (int)this.outputTank.getCapacity(), (EntityPlayer)player, (boolean)true);
            if (result2.isSuccess()) {
                playerStack.func_190918_g(1);
                ItemStack resultStack = result2.getResult();
                if (!resultStack.func_190926_b() && !player.field_71071_by.func_70441_a(resultStack)) {
                    player.func_71019_a(resultStack, false);
                }
                return true;
            }
        }
        return false;
    }

    public boolean hasLeftClick() {
        return false;
    }

    public void onLeftClick(EntityPlayer entityPlayer, Side side) {
    }

    @Optional.Method(modid="gtclassic")
    public void getData(Map<String, Boolean> map) {
        FluidStack fluid = this.inputTank.getFluid();
        map.put("Input Tank: " + (fluid != null ? fluid.amount + "mb of " + fluid.getLocalizedName() : "Empty"), false);
        fluid = this.outputTank.getFluid();
        map.put("Output Tank: " + (fluid != null ? fluid.amount + "mb of " + fluid.getLocalizedName() : "Empty"), false);
    }

    public IFluidTankProperties[] getTankProperties() {
        ArrayList<IFluidTankProperties> list = new ArrayList<IFluidTankProperties>();
        list.addAll(Arrays.asList(this.inputTank.getTankProperties()));
        list.addAll(Arrays.asList(this.outputTank.getTankProperties()));
        return list.toArray(new IFluidTankProperties[0]);
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.inputTank.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.outputTank.drain(resource, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.outputTank.drain(maxDrain, doDrain);
    }
}

