/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.tileentity;

import gtclassic.api.interfaces.IGTDebuggableTile;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityGeneratorBase;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.util.math.Box2D;
import ic2.core.util.math.Vec2i;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Optional;
import trinsdar.ic2c_extras.container.ContainerThermoElectricGenerator;
import trinsdar.ic2c_extras.util.Registry;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasLang;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasResourceLocations;

@Optional.Interface(modid="gtclassic", iface="gtclassic.api.interfaces.IGTDebuggableTile", striprefs=true)
public abstract class TileEntityThermoElectricGeneratorBase
extends TileEntityGeneratorBase
implements IGTDebuggableTile {
    protected boolean checkProduction = true;
    int counter = 0;

    public TileEntityThermoElectricGeneratorBase() {
        super(6);
        this.tier = 1;
        this.maxStorage = 20000;
    }

    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.UP.invert());
        handler.registerDefaultSlotAccess(AccessRule.Import, new int[]{0, 1, 2, 3, 4, 5});
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), new int[]{0, 1, 2, 3, 4, 5});
        handler.registerSlotType(SlotType.Input, new int[]{0, 1, 2, 3, 4, 5});
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.production = nbt.func_74762_e("Production");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Production", this.production);
        return nbt;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(slot, stack);
        this.checkProduction = true;
    }

    public int getMaxStackSize(int slot) {
        return 1;
    }

    public abstract BasicItemFilter getFilter();

    public int getOutput() {
        return this.production;
    }

    public abstract int getProduction();

    public double getWrenchDropRate() {
        return 1.0;
    }

    public boolean isConverting() {
        return this.storage + this.production <= this.maxStorage;
    }

    public int getMaxSendingEnergy() {
        return 32 * this.tier;
    }

    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return true;
    }

    public void onLoaded() {
        super.onLoaded();
    }

    public void func_73660_a() {
        int oldEnergy = this.storage;
        if (this.checkProduction) {
            int newProduction = this.getProduction();
            if (this.production != newProduction) {
                this.production = newProduction;
            }
            this.checkProduction = false;
        }
        boolean active = this.gainEnergy();
        if (this.storage > 0 && this.storage > this.maxStorage) {
            this.storage = this.maxStorage;
        }
        this.setActive(active);
        if (oldEnergy != this.storage) {
            this.getNetwork().updateTileGuiField((TileEntity)this, "storage");
        }
        this.updateComparators();
    }

    public boolean gainEnergy() {
        if (this.isConverting() && this.production > 0) {
            this.storage += this.production;
            this.getNetwork().updateTileGuiField((TileEntity)this, "fuel");
            return true;
        }
        return false;
    }

    public ResourceLocation getTexture() {
        return Ic2cExtrasResourceLocations.THERMO_ELECTRIC_GENERATOR;
    }

    public Box2D getEnergyBox() {
        return Ic2GuiComp.generatorEnergyBox;
    }

    public Vec2i getEnergyPos() {
        return Ic2GuiComp.machineChargePos;
    }

    public boolean gainFuel() {
        return false;
    }

    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerThermoElectricGenerator(entityPlayer.field_71071_by, this);
    }

    public void getData(Map<String, Boolean> map) {
        map.put("Production: " + this.production, true);
    }

    public static class TileEntityThermoElectricGenerator
    extends TileEntityThermoElectricGeneratorBase {
        public static BasicItemFilter filter = new BasicItemFilter(new ItemStack((Item)Registry.plutoniumRTG));

        public TileEntityThermoElectricGenerator() {
            this.tier = 1;
            this.maxStorage = 20000;
        }

        @Override
        public BasicItemFilter getFilter() {
            return filter;
        }

        public LocaleComp getBlockName() {
            return Ic2cExtrasLang.THERMO_ELECTRIC_GENERATOR;
        }

        @Override
        public int getProduction() {
            int count = -1;
            for (int i = 0; i < 6; ++i) {
                if (!((ItemStack)this.inventory.get(i)).func_77969_a(new ItemStack((Item)Registry.plutoniumRTG))) continue;
                ++count;
            }
            if (count == -1) {
                return 0;
            }
            return (int)Math.pow(2.0, count);
        }

        public double getOfferedEnergy() {
            return Math.min(this.storage, 32);
        }
    }
}

