/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util;

import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.Sprites;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.IC2CExtras;
import trinsdar.ic2c_extras.Ic2cExtrasConfig;
import trinsdar.ic2c_extras.util.Registry;

public class Icons {
    private static final Map<Block, IconInfo[]> TEXTURE_MAP = new HashMap<Block, IconInfo[]>();
    private static final List<String> blockTextureList = new ArrayList<String>();
    private static final IconInfo[] SET_NULL = new IconInfo[]{Icons.s(4, 6), Icons.s(4, 6)};
    private static final IconInfo[] SET_INVALID_SIZE = new IconInfo[]{Icons.s(5, 6), Icons.s(5, 6)};

    @SideOnly(value=Side.CLIENT)
    public static void loadSprites() {
        Icons.makeSprites("blocks", 2, 2);
        IconInfo side = Icons.s(35);
        IconInfo top = Icons.s(22);
        IconInfo bottom = Icons.s(3);
        IconInfo common = Icons.s(36);
        IconInfo common2 = Icons.s(44);
        Icons.setTexture((Block)Registry.thermalCentrifuge, bottom, Icons.s(19), side, Icons.s(4, 1), side, side, bottom, Icons.s(115), side, Icons.s(4, 2), side, side);
        Icons.setTexture((Block)Registry.thermalWasher, bottom, Icons.s(19), side, Icons.s(4, 1), Icons.s("bmach_mv", 140), Icons.s("bmach_mv", 140), bottom, Icons.s(115), side, Icons.s(5, 1), Icons.s("bmach_mv", 44), Icons.s("bmach_mv", 44));
        Icons.setTexture((Block)Registry.oreWashingPlant, bottom, Icons.s(19), side, Icons.s(4, 1), common, common, bottom, Icons.s(115), side, Icons.s(5, 1), Icons.s(43), Icons.s(43));
        Icons.setTexture((Block)Registry.roller, bottom, Icons.s(20), side, Icons.s(1, 2), common, common, bottom, Icons.s(3, 2), side, Icons.s(2, 2), common2, common2);
        Icons.setTexture((Block)Registry.extruder, bottom, Icons.s(20), side, Icons.s(155), common, common, bottom, Icons.s(3, 2), side, Icons.s(0, 1), common2, common2);
        Icons.setTexture((Block)Registry.cutter, bottom, Icons.s(20), side, Icons.s(4, 0), common, common, bottom, Icons.s(3, 2), side, Icons.s(5, 0), common2, common2);
        Icons.setTexture((Block)Registry.metalBender, bottom, Icons.s(20), side, Icons.s(2, 1), common, common, bottom, Icons.s(3, 2), side, Icons.s(3, 1), common2, common2);
        common = Icons.s("bmach_lv_2", 53);
        Icons.setTexture((Block)Registry.fluidCanningMachine, bottom, top, side, Icons.s(54), common, common, bottom, top, side, Icons.s(150), common, common);
        common = Icons.s(0, 3);
        common2 = Icons.s(1, 3);
        Icons.setTexture((Block)Registry.treeTapper, bottom, Icons.s("bmach_mv", 27), common, common, common, common, bottom, Icons.s("bmach_mv", 123), common2, common2, common2, common2);
        Icons.setTexture((Block)Registry.impellerizedRoller, bottom, Icons.s(20), side, Icons.s(1, 2), Icons.s("bmach_mv", 140), Icons.s("bmach_mv", 140), bottom, Icons.s(3, 2), side, Icons.s(2, 2), Icons.s(1, 1), Icons.s(1, 1));
        Icons.setTexture((Block)Registry.liquescentExtruder, bottom, Icons.s(20), side, Icons.s(155), Icons.s("bmach_mv", 140), Icons.s("bmach_mv", 140), bottom, Icons.s(3, 2), side, Icons.s(0, 1), Icons.s(1, 1), Icons.s(1, 1));
        Icons.setTexture((Block)Registry.plasmaCutter, bottom, Icons.s(20), side, Icons.s(4, 0), Icons.s("bmach_mv", 140), Icons.s("bmach_mv", 140), bottom, Icons.s(3, 2), side, Icons.s(5, 0), Icons.s(1, 1), Icons.s(1, 1));
        common = Icons.s(0, 0);
        Icons.setTexture((Block)Registry.advancedSteamTurbine, Icons.s(1), top, common, Icons.s("bgen", 58), common, common, Icons.s(1), top, common, Icons.s("bgen", 160), common, common);
        common = Icons.s("bgen", 22);
        Icons.setTexture((Block)Registry.thermoElectricGenerator, Icons.s(1), top, common, Icons.s("bgen", 39), common, common, Icons.s(1), top, common, Icons.s("bgen", 141), common, common);
        common = Icons.s("bmach_hv", 36);
        common2 = Icons.s("bmach_hv", 132);
        Icons.setTexture((Block)Registry.electricDisenchanter, Icons.s("bmach_mv", 0), Icons.s("electric_disenchanter_top"), common, common, common, common, Icons.s("bmach_mv", 0), Icons.s("electric_disenchanter_top"), common2, common2, common2, common2);
        Icons.setTexture((Block)Registry.autocraftingTable, Icons.s(3, 0), Icons.s(3, 0), Icons.s(1, 0), Icons.s(2, 0), Icons.s(3, 0), Icons.s(3, 0));
        Icons.setTexture((Block)Registry.reinforcedEncasedCable, Icons.s("b0", 12), Icons.s("b0", 12), Icons.s(0, 2), Icons.s(0, 2), Icons.s("b0", 12), Icons.s("b0", 12));
        Icons.setTexture((Block)Registry.electricHeatGenerator, bottom, Icons.s(0, 5), Icons.s(2, 3), Icons.s(4, 3), Icons.s(0, 4), Icons.s(0, 4), bottom, Icons.s(1, 5), Icons.s(3, 3), Icons.s(5, 3), Icons.s(1, 4), Icons.s(1, 4));
        Icons.setTexture((Block)Registry.fermenter, bottom, top, Icons.s(2, 4), Icons.s(4, 3), Icons.s(4, 4), Icons.s(4, 4), bottom, top, Icons.s(3, 4), Icons.s(5, 3), Icons.s(5, 4), Icons.s(5, 4));
        blockTextureList.add("electric_disenchanter_side_overlay");
        blockTextureList.add("electric_disenchanter_side_active_overlay");
        Icons.makeSprites("misc_items", 16, 2);
        Icons.makeSprites("tiles", 6, 7);
        Icons.makeSprites("crushed_ore", 7, 1);
        Icons.makeSprites("purified_crushed_ore", 7, 1);
        Icons.makeSprites("item_casings", 16, 1);
        Icons.makeSprites("plates", 16, 1);
        Icons.makeSprites("materials", 5, 1);
        Icons.makeSprites("presses", 16, 2);
        Icons.makeSprites("small_dust", 16, 1);
        Icons.makeSprites("tiny_dust", 16, 1);
        Icons.makeSprites("tools", 6, 1);
        Icons.makeSprites("nuclear_cells", 6, 6);
        Icons.makeSprites("crops", 1, 1);
        Icons.makeSprites("aluminum", 3, 1);
        Icons.makeSprites("nickel", 3, 1);
        Icons.makeSprites("platinum", 3, 1);
        Icons.collectBasicTileSprites();
        Ic2Icons.addCustomTexture((String)"ic2c_extras_tiles", (int)3, (int)1, (ResourceLocation)new ResourceLocation("ic2c_extras", "animations/metal_bender_front"));
    }

    public static void makeSprites(String name, int maxX, int maxY) {
        String id = "ic2c_extras_" + name;
        Ic2Icons.addSprite((Sprites.SpriteData)new Sprites.SpriteData(id, "ic2c_extras:textures/sprites/" + name + ".png", new Sprites.SpriteInfo(maxX, maxY)));
        Ic2Icons.addTextureEntry((Sprites.TextureEntry)new Sprites.TextureEntry(id, 0, 0, maxX, maxY));
    }

    public static void collectBasicTileSprites() {
        for (String string : blockTextureList) {
            if (Ic2cExtrasConfig.debugMode) {
                IC2CExtras.logger.info("Attempting to get sprite data for: " + string);
            }
            Ic2Icons.addSprite((Sprites.SpriteData)new Sprites.SpriteData(string, "ic2c_extras:textures/sprites/tiles/" + string + ".png", new Sprites.SpriteInfo(1, 1)));
            Ic2Icons.addTextureEntry((Sprites.TextureEntry)new Sprites.TextureEntry(string, 0, 0, 1, 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite[] getTextureData(Block block) {
        return TEXTURE_MAP.containsKey(block) ? Icons.textureHelper(TEXTURE_MAP.get(block)) : Icons.textureHelper(SET_NULL);
    }

    @SideOnly(value=Side.CLIENT)
    private static void setTexture(Block block, IconInfo ... values) {
        TEXTURE_MAP.put(block, values);
    }

    @SideOnly(value=Side.CLIENT)
    private static TextureAtlasSprite[] textureHelper(IconInfo[] arr) {
        if (arr.length == 2) {
            return Icons.buildTexture(arr[0], arr[0], arr[0], arr[0], arr[0], arr[0], arr[1], arr[1], arr[1], arr[1], arr[1], arr[1]);
        }
        if (arr.length == 6) {
            return Icons.buildTexture(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[0], arr[1], arr[2], arr[3], arr[4], arr[5]);
        }
        if (arr.length == 12) {
            return Icons.buildTexture(arr[0], arr[1], arr[2], arr[3], arr[4], arr[5], arr[6], arr[7], arr[8], arr[9], arr[10], arr[11]);
        }
        return Icons.textureHelper(SET_INVALID_SIZE);
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite[] buildTexture(IconInfo ... arr) {
        TextureAtlasSprite[] texture = new TextureAtlasSprite[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            texture[i] = arr[i].getSprite();
        }
        return texture;
    }

    public static IconInfo s(String spriteName) {
        if (!blockTextureList.contains(spriteName)) {
            blockTextureList.add(spriteName);
        }
        return new IconInfo(spriteName);
    }

    public static IconInfo s(int spriteId) {
        return new IconInfo(spriteId);
    }

    public static IconInfo s(int x, int y) {
        return new IconInfo("ic2c_extras_tiles", x + 6 * y);
    }

    public static IconInfo s(String spriteName, int spriteId) {
        return new IconInfo(spriteName, spriteId);
    }

    public static class IconInfo {
        int spriteId;
        String spriteName;

        public IconInfo(String spriteName, int spriteId) {
            this.spriteName = spriteName;
            this.spriteId = spriteId;
        }

        public IconInfo(String spriteName) {
            this.spriteName = spriteName;
            this.spriteId = 0;
        }

        public IconInfo(int spriteId) {
            this.spriteName = "bmach_lv";
            this.spriteId = spriteId;
        }

        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getSprite() {
            return Ic2Icons.getTextures((String)this.spriteName)[this.spriteId];
        }
    }
}

