/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util.fluidcell;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fluids.Fluid;
import trinsdar.ic2c_extras.util.fluidcell.BakedFluidCell;
import trinsdar.ic2c_extras.util.fluidcell.ModelUtils;

public class ModelFluidCell
implements IModel {
    private static ResourceLocation BASE = new ResourceLocation("ic2c_extras", "items/universal_fluid_cell");
    private static IBakedModel BAKED_BASE;
    private static IBakedModel BAKED_OVERLAY;
    private Fluid fluid;

    public ModelFluidCell() {
    }

    public ModelFluidCell(Fluid fluid) {
        this.fluid = fluid;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> getter) {
        TextureAtlasSprite sprite;
        if (BAKED_BASE == null) {
            BAKED_BASE = ModelUtils.load("ic2c_extras", "universal_fluid_cell_model").bake(state, format, getter);
        }
        if (BAKED_OVERLAY == null) {
            BAKED_OVERLAY = ModelUtils.load("ic2c_extras", "universal_fluid_cell_overlay_model").bake(state, format, getter);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.fluid != null && (sprite = getter.apply(this.fluid.getStill())) != null) {
            List<BakedQuad> quads = BAKED_OVERLAY.func_188616_a(null, null, 0L);
            quads = ModelUtils.texAndTint(quads, this.fluid.getColor(), sprite);
            builder.addAll(quads);
        }
        builder.addAll((Iterable)BAKED_BASE.func_188616_a(null, null, 0L));
        return new BakedFluidCell((List<BakedQuad>)builder.build(), this, getter.apply(BASE), format);
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.singletonList(BASE);
    }
}

