/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util.recipelists;

import ic2.api.recipe.IFermenterRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.core.block.machine.recipes.managers.RecipeManager;
import ic2.core.util.helpers.CompareableStack;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.Tuple;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import trinsdar.ic2c_extras.IC2CExtras;

public class FermenterRecipeManager
implements IFermenterRecipeManager {
    public static final IFermenterRecipeManager.FermentationProperty INVALID_RECIPE = new IFermenterRecipeManager.FermentationProperty(0, 0, "", 0);
    protected Map<String, IFermenterRecipeManager.FermentationProperty> recipes = new LinkedHashMap<String, IFermenterRecipeManager.FermentationProperty>();
    protected Map<String, Tuple<String, IFermenterRecipeManager.FermentationProperty>> recipeMap = new LinkedHashMap<String, Tuple<String, IFermenterRecipeManager.FermentationProperty>>();
    protected Map<CompareableStack, IRecipeInput> validInputs = new LinkedHashMap<CompareableStack, IRecipeInput>();
    String category;

    public FermenterRecipeManager(String category) {
        this.category = category;
    }

    public void addRecipe(String input, int inputAmount, int heat, String output, int outputAmount) {
        String id = FermenterRecipeManager.getRecipeID(this.recipeMap.keySet(), input, 0);
        if (this.recipeMap.containsKey(id) || !RecipeManager.register((String)this.category, (String)id)) {
            return;
        }
        if (!FluidRegistry.isFluidRegistered((String)input)) {
            IC2CExtras.logger.info("Recipe[" + id + "] has a invalid input for machine " + this.category);
            return;
        }
        if (!FluidRegistry.isFluidRegistered((String)output)) {
            IC2CExtras.logger.info("Recipe[" + id + "] has a invalid output for machine " + this.category);
            IC2CExtras.logger.info("Recipe[" + input + "] as input " + this.category);
            return;
        }
        if (this.recipes.containsKey(input)) {
            IC2CExtras.logger.info(input + " already registered as a recipe for machine " + this.category);
            return;
        }
        IFermenterRecipeManager.FermentationProperty recipe = new IFermenterRecipeManager.FermentationProperty(inputAmount, heat, output, outputAmount);
        this.recipes.put(input, recipe);
        this.recipeMap.put(id, (Tuple<String, IFermenterRecipeManager.FermentationProperty>)new Tuple((Object)input, (Object)recipe));
    }

    public static String getRecipeID(Set<String> ids, String base, int index) {
        String newString = base;
        if (index > 0) {
            newString = newString + "_" + index;
        }
        if (ids.contains(newString)) {
            return FermenterRecipeManager.getRecipeID(ids, base, index + 1);
        }
        return newString;
    }

    public IFermenterRecipeManager.FermentationProperty getFermentationInformation(Fluid fluid) {
        return this.recipes.getOrDefault(fluid.getName(), null);
    }

    public FluidStack getOutput(Fluid fluid) {
        return this.recipes.containsKey(fluid.getName()) ? this.recipes.get(fluid.getName()).getOutput() : null;
    }

    public Map<String, IFermenterRecipeManager.FermentationProperty> getRecipeMap() {
        return this.recipes;
    }

    public Map<String, Tuple<String, IFermenterRecipeManager.FermentationProperty>> getRecipeMap2() {
        return this.recipeMap;
    }

    public boolean acceptsFluid(Fluid fluid) {
        return this.recipes.containsKey(fluid.getName());
    }

    public Set<Fluid> getAcceptedFluids() {
        LinkedHashSet<Fluid> fluids = new LinkedHashSet<Fluid>();
        for (String key : this.recipes.keySet()) {
            if (!FluidRegistry.isFluidRegistered((String)key)) continue;
            fluids.add(FluidRegistry.getFluid((String)key));
        }
        return fluids;
    }
}

