/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.config.recipes.IRecipeConfigElement;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.ItemOptional;
import crazypants.enderio.base.handler.darksteel.UpgradeRegistry;
import java.util.Locale;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class ConditionDependency
implements IRecipeConfigElement {
    private Optional<String> itemString = this.empty();
    private Optional<String> modString = this.empty();
    private Optional<String> upgradeString = this.empty();
    private boolean reverse;
    private boolean valid;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            if (!(this.itemString.isPresent() || this.modString.isPresent() || this.upgradeString.isPresent())) {
                throw new InvalidRecipeConfigException("Missing item and mod and upgrade");
            }
            this.valid = true;
            if (this.itemString.isPresent()) {
                Object item = new ItemOptional().setAllowDelaying(false);
                ((ItemOptional)item).setName(this.get(this.itemString));
                ((ItemOptional)item).readResolve();
                boolean bl = this.valid = this.valid && ((ItemOptional)item).isValid();
            }
            if (this.upgradeString.isPresent()) {
                if (this.upgradeString.get().length() > 64) {
                    throw new InvalidRecipeConfigException(String.format("The upgrade ID %s is longer than the maximum of 64 characters.", this.upgradeString.get()));
                }
                if (!this.upgradeString.get().equals(this.upgradeString.get().toLowerCase(Locale.ENGLISH))) {
                    throw new InvalidRecipeConfigException(String.format("The upgrade ID %s must be all lowercase.", this.upgradeString.get()));
                }
                boolean bl = this.valid = this.valid && UpgradeRegistry.getUpgrade(new ResourceLocation(this.get(this.upgradeString))) != null;
            }
            if (this.modString.isPresent()) {
                if (this.modString.get().length() > 64) {
                    throw new InvalidRecipeConfigException(String.format("The modId %s is longer than the maximum of 64 characters.", this.modString.get()));
                }
                if (!this.modString.get().equals(this.modString.get().toLowerCase(Locale.ENGLISH))) {
                    throw new InvalidRecipeConfigException(String.format("The modId %s must be all lowercase.", this.modString.get()));
                }
                this.valid = this.valid && Loader.isModLoaded((String)this.modString.get());
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <dependency>");
        }
        return this;
    }

    @Override
    public boolean isValid() {
        return this.valid != this.reverse;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("item".equals(name)) {
            this.itemString = this.ofString(value);
            return true;
        }
        if ("mod".equals(name)) {
            this.modString = this.ofString(value);
            return true;
        }
        if ("upgrade".equals(name)) {
            this.upgradeString = this.ofString(value);
            return true;
        }
        if ("reverse".equals(name)) {
            this.reverse = Boolean.parseBoolean(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
    }

    protected Optional<String> getItemString() {
        return this.itemString;
    }

    protected Optional<String> getModString() {
        return this.modString;
    }

    protected Optional<String> getUpgradeString() {
        return this.upgradeString;
    }

    protected boolean isReverse() {
        return this.reverse;
    }
}

