/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Item;
import crazypants.enderio.base.recipe.RecipeLevel;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;

public class Output
extends AbstractConditional {
    private int amount;
    private Optional<String> nbt = this.empty();
    private Optional<Item> item = this.empty();
    private boolean required = true;
    private boolean invalidStackSize = false;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        super.readResolve();
        if (!this.item.isPresent()) {
            throw new InvalidRecipeConfigException("Missing name in <output>");
        }
        if (this.amount < 0) {
            throw new InvalidRecipeConfigException("Invalid negative amount in <output>");
        }
        if (this.amount == 0) {
            this.amount = 1;
        } else if (this.amount > this.item.get().getItemStack().func_77976_d()) {
            this.invalidStackSize = true;
        } else {
            this.item.get().getThing().setSize(this.amount);
        }
        if (this.nbt.isPresent()) {
            try {
                this.item.get().getThing().setNbt(JsonToNBT.func_180713_a((String)this.get(this.nbt)));
            }
            catch (NBTException e) {
                throw new InvalidRecipeConfigException("'" + this.nbt.get() + "' is not valid NBT json");
            }
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        this.item.get().enforceValidity();
        if (this.invalidStackSize) {
            throw new InvalidRecipeConfigException("Invalid amount in <output>, bigger than maximum stack size");
        }
    }

    @Override
    public boolean isValid() {
        return this.item.isPresent() && this.item.get().isValid() && !this.invalidStackSize;
    }

    @Override
    public boolean isActive() {
        return super.isActive() && (this.required || this.isValid());
    }

    public ItemStack getItemStack() {
        ItemStack itemStack = this.item.get().getItemStack().func_77946_l();
        itemStack.func_190920_e(this.amount);
        return itemStack;
    }

    public boolean hasAlternatives() {
        return this.getThing().getItemStacks().size() > 1;
    }

    public NNList<ItemStack> getAlternatives() {
        NNList list = this.getThing().getItemStacks().copy();
        list.remove(0);
        for (ItemStack itemStack : list) {
            itemStack.func_190920_e(this.amount);
        }
        return list;
    }

    public Things getThing() {
        return this.item.get().getThing();
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("amount".equals(name)) {
            this.amount = Integer.valueOf(value);
            return true;
        }
        if ("nbt".equals(name)) {
            this.nbt = this.ofString(value);
            return true;
        }
        if ("name".equals(name)) {
            Item item = (Item)new Item().setAllowDelaying(false);
            item.setName(value);
            item.readResolve();
            this.item = this.of(item);
            return true;
        }
        if ("required".equals(name)) {
            this.required = Boolean.parseBoolean(value);
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public void register(@Nonnull String recipeName, RecipeLevel recipeLevel) {
    }
}

