/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler;

import com.enderio.core.common.util.NullHelper;
import com.google.common.collect.ImmutableSet;
import crazypants.enderio.base.config.config.DiagnosticsConfig;
import crazypants.enderio.base.diagnostics.Prof;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.profiler.Profiler;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="enderio")
public class ServerTickHandler {
    @Nonnull
    private static final IdentityHashMap<ITickListener, String> listeners = new IdentityHashMap();
    @Nonnull
    private static final WeakHashMap<WorldServer, IdentityHashMap<IServerTickListener, String>> worldListeners = new WeakHashMap();

    @Deprecated
    public static void addListener(@Nonnull ITickListener listener) {
        listeners.put(listener, listener.getClass().getSimpleName());
    }

    public static void addListener(@Nonnull World world, @Nonnull IServerTickListener listener) {
        if (world instanceof WorldServer) {
            ServerTickHandler.addListener((WorldServer)world, listener);
        }
    }

    public static void addListener(@Nonnull WorldServer world, @Nonnull IServerTickListener listener) {
        worldListeners.computeIfAbsent(world, k -> new IdentityHashMap()).put(listener, listener.getClass().getSimpleName());
    }

    public static void removeListener(@Nonnull Object listener) {
        listeners.remove(listener);
        worldListeners.forEach((k, v) -> {
            String cfr_ignored_0 = (String)v.remove(listener);
        });
    }

    @SubscribeEvent
    public static void flush(EnderIOLifecycleEvent.ServerStopped.Post event) {
        listeners.clear();
        worldListeners.clear();
    }

    @SubscribeEvent
    public static void onWorldTick(@Nonnull TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            throw new RuntimeException("TickEvent.WorldTickEvent was fired for a client world. This should not happen, some mod is messing with things it has no clue about.");
        }
        Profiler profiler = event.world.field_72984_F.field_76327_a ? event.world.field_72984_F : null;
        Prof.start(profiler, "WorldTickEvent_" + event.phase);
        Prof.start(profiler, "Dim" + event.world.field_73011_w.getDimension());
        worldListeners.computeIfAbsent((WorldServer)event.world, k -> new IdentityHashMap()).forEach((listener, name) -> {
            Prof.start(profiler, (String)NullHelper.first((Object[])new String[]{name, "(unnamed)"}));
            if (event.phase == TickEvent.Phase.START) {
                listener.tickStart(profiler);
            } else {
                listener.tickEnd(profiler);
            }
            Prof.stop(profiler);
        });
        Prof.stop(profiler, 2);
    }

    @SubscribeEvent
    public static void onServerTick(@Nonnull TickEvent.ServerTickEvent event) {
        Profiler profiler = FMLCommonHandler.instance().getMinecraftServerInstance().field_71304_b;
        if (!profiler.field_76327_a) {
            profiler = null;
        } else if (((Boolean)DiagnosticsConfig.debugProfilerResetOnServerTick.get()).booleanValue()) {
            String lastSection = profiler.func_76322_c();
            while (!"[UNKNOWN]".equals(lastSection)) {
                profiler.func_76319_b();
                lastSection = profiler.func_76322_c();
            }
        }
        Prof.start(profiler, "root");
        Prof.start(profiler, "ServerTickEvent_" + event.phase);
        for (Map.Entry entry : ImmutableSet.copyOf((Collection)((Collection)NullHelper.notnullJ(listeners.entrySet(), (String)"IdentityHashMap.entrySet()")))) {
            Prof.start(profiler, (String)NullHelper.first((Object[])new String[]{(String)entry.getValue(), "(unnamed)"}));
            if (event.phase == TickEvent.Phase.START) {
                ((ITickListener)entry.getKey()).tickStart(event, profiler);
            } else {
                ((ITickListener)entry.getKey()).tickEnd(event, profiler);
            }
            Prof.stop(profiler);
        }
        Prof.stop(profiler, 2);
    }

    public static interface IServerTickListener {
        default public void tickStart(@Nullable Profiler profiler) {
        }

        default public void tickEnd(@Nullable Profiler profiler) {
        }
    }

    @Deprecated
    public static interface ITickListener {
        public void tickStart(TickEvent.ServerTickEvent var1, @Nullable Profiler var2);

        public void tickEnd(TickEvent.ServerTickEvent var1, @Nullable Profiler var2);
    }
}

