/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.bigreactors;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.config.IntegrationConfig;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.integration.bigreactors.BRRegistrations;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@Mod.EventBusSubscriber(modid="enderio")
public class BRProxy {
    private static boolean isLoaded = false;
    private static Class<Object> ReactorInterior;
    private static Class<Object> TurbineCoil;
    private static Method registerBlock;
    private static Method registerFluid;
    private static Method registerTurbineBlock;
    private static Method getBlockData;
    private static Method getFluidData;
    private static Method getTurbineBlockData;

    @SubscribeEvent
    public static void init(@Nonnull EnderIOLifecycleEvent.Init.Normal event) {
        if (Loader.isModLoaded((String)"bigreactors") && ((Boolean)IntegrationConfig.enableBigReactors.get()).booleanValue()) {
            try {
                ReactorInterior = ReflectionHelper.getClass((ClassLoader)BRProxy.class.getClassLoader(), (String[])new String[]{"erogenousbeef.bigreactors.api.registry.ReactorInterior"});
                getBlockData = ReflectionHelper.findMethod(ReactorInterior, (String)"getBlockData", (String)"getBlockData", (Class[])new Class[]{String.class});
                registerBlock = ReflectionHelper.findMethod(ReactorInterior, (String)"registerBlock", (String)"registerBlock", (Class[])new Class[]{String.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE});
                getFluidData = ReflectionHelper.findMethod(ReactorInterior, (String)"getFluidData", (String)"getFluidData", (Class[])new Class[]{String.class});
                registerFluid = ReflectionHelper.findMethod(ReactorInterior, (String)"registerFluid", (String)"registerFluid", (Class[])new Class[]{String.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE});
                TurbineCoil = ReflectionHelper.getClass((ClassLoader)BRProxy.class.getClassLoader(), (String[])new String[]{"erogenousbeef.bigreactors.api.registry.TurbineCoil"});
                getTurbineBlockData = ReflectionHelper.findMethod(TurbineCoil, (String)"getBlockData", (String)"getBlockData", (Class[])new Class[]{String.class});
                registerTurbineBlock = ReflectionHelper.findMethod(TurbineCoil, (String)"registerBlock", (String)"registerBlock", (Class[])new Class[]{String.class, Float.TYPE, Float.TYPE, Float.TYPE});
                isLoaded = true;
                BRRegistrations.init(event.getEvent());
            }
            catch (RuntimeException e) {
                Log.error("Failed to load Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
        }
    }

    public static boolean isBlockRegistered(String oreDictName) {
        if (isLoaded) {
            try {
                return getBlockData.invoke(null, oreDictName) != null;
            }
            catch (IllegalAccessException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void registerBlock(String oreDictName, float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        if (isLoaded && !BRProxy.isBlockRegistered(oreDictName)) {
            try {
                registerBlock.invoke(null, oreDictName, Float.valueOf(absorption), Float.valueOf(heatEfficiency), Float.valueOf(moderation), Float.valueOf(heatConductivity));
            }
            catch (IllegalAccessException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
        }
    }

    public static boolean isFluidRegistered(String fluidName) {
        if (isLoaded) {
            try {
                return getFluidData.invoke(null, fluidName) != null;
            }
            catch (IllegalAccessException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void registerFluid(String fluidName, float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        if (isLoaded && !BRProxy.isFluidRegistered(fluidName)) {
            try {
                registerFluid.invoke(null, fluidName, Float.valueOf(absorption), Float.valueOf(heatEfficiency), Float.valueOf(moderation), Float.valueOf(heatConductivity));
            }
            catch (IllegalAccessException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
        }
    }

    public static boolean isTurbineBlockRegistered(String oreDictName) {
        if (isLoaded) {
            try {
                return getTurbineBlockData.invoke(null, oreDictName) != null;
            }
            catch (IllegalAccessException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void registerTurbineBlock(String oreDictName, float efficiency, float bonus, float extractionRate) {
        if (isLoaded && !BRProxy.isTurbineBlockRegistered(oreDictName)) {
            try {
                registerTurbineBlock.invoke(null, oreDictName, Float.valueOf(efficiency), Float.valueOf(bonus), Float.valueOf(extractionRate));
            }
            catch (IllegalAccessException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Log.error("Failed to access Extreme Reactors integration. Reason:");
                e.printStackTrace();
            }
        }
    }
}

