/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.magnet;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.interfaces.IOverlayRenderAware;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.upgrades.IHasPlayerRenderer;
import crazypants.enderio.api.upgrades.IRenderUpgrade;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.config.config.ItemConfig;
import crazypants.enderio.base.integration.baubles.BaublesUtil;
import crazypants.enderio.base.item.magnet.MagnetController;
import crazypants.enderio.base.item.magnet.MagnetLayer;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.power.forge.item.AbstractPoweredItem;
import crazypants.enderio.base.power.forge.item.IInternalPoweredItem;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.util.NbtValue;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles|API")
public class ItemMagnet
extends AbstractPoweredItem
implements IResourceTooltipProvider,
IBauble,
IOverlayRenderAware,
IHasPlayerRenderer {
    public static ItemMagnet create(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemMagnet(modObject);
    }

    protected ItemMagnet(@Nonnull IModObject modObject) {
        super((Integer)ItemConfig.magnetPowerCapacity.get(), (Integer)ItemConfig.magnetPowerCapacity.get() / 100, 0);
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public static void setActive(@Nonnull ItemStack item, boolean active) {
        NbtValue.MAGNET_ACTIVE.setBoolean(item, active);
    }

    public static boolean isMagnet(ItemStack item) {
        return item != null && item.func_77973_b() instanceof ItemMagnet;
    }

    public static boolean isActive(@Nonnull ItemStack item) {
        return ItemMagnet.isMagnet(item) && NbtValue.MAGNET_ACTIVE.getBoolean(item);
    }

    public static boolean hasPower(@Nonnull ItemStack itemStack) {
        int energyStored = itemStack.func_77973_b() instanceof IInternalPoweredItem ? ((IInternalPoweredItem)itemStack.func_77973_b()).getEnergyStored(itemStack) : 0;
        return energyStored > 0 && energyStored >= (Integer)ItemConfig.magnetPowerUsePerSecond.get();
    }

    public void drainPerSecondPower(@Nonnull ItemStack itemStack) {
        this.extractEnergyInternal(itemStack, (Integer)ItemConfig.magnetPowerUsePerSecond.get());
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack is = new ItemStack((Item)this);
            list.add((Object)is);
            is = new ItemStack((Item)this);
            this.setFull(is);
            list.add((Object)is);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(LangPower.RF(this.getEnergyStored(stack), (Integer)ItemConfig.magnetPowerCapacity.get()));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(@Nonnull ItemStack item) {
        return ItemMagnet.isActive(item);
    }

    public void func_77622_d(@Nonnull ItemStack itemStack, @Nonnull World world, @Nonnull EntityPlayer entityPlayer) {
        this.setEnergyStored(itemStack, 0);
    }

    private void extractEnergyInternal(@Nonnull ItemStack itemStack, int extract) {
        if (extract <= 0) {
            return;
        }
        int energy = this.getEnergyStored(itemStack);
        energy = Math.max(0, energy - extract);
        this.setEnergyStored(itemStack, energy);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (player.func_70093_af()) {
            ItemStack equipped;
            ItemMagnet.setActive(equipped, !ItemMagnet.isActive(equipped = player.func_184586_b(hand)));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
        }
        return super.func_77659_a(world, player, hand);
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack stack) {
        return this.func_77658_a() + ((Boolean)ItemConfig.magnetAllowInMainInventory.get() != false ? ".everywhere" : "");
    }

    @Optional.Method(modid="Baubles|API")
    public BaubleType getBaubleType(ItemStack itemstack) {
        BaubleType t = null;
        try {
            t = BaubleType.valueOf((String)((String)ItemConfig.magnetBaublesType.get()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t != null ? t : BaubleType.AMULET;
    }

    @Optional.Method(modid="Baubles|API")
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (itemstack == null || player == null) {
            return;
        }
        if (player instanceof EntityPlayer && ItemMagnet.isActive(itemstack) && ItemMagnet.hasPower(itemstack) && ((EntityPlayer)player).func_110143_aJ() > 0.0f) {
            MagnetController.doHoover((EntityPlayer)player);
            if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_82737_E() % 20L == 0L) {
                ItemStack changedStack = itemstack.func_77946_l();
                this.drainPerSecondPower(changedStack);
                IInventory baubles = BaublesUtil.instance().getBaubles((EntityPlayer)player);
                if (baubles != null) {
                    for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                        if (baubles.func_70301_a(i) != itemstack) continue;
                        baubles.func_70299_a(i, changedStack);
                    }
                }
            }
        }
    }

    @Optional.Method(modid="Baubles|API")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles|API")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles|API")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        if (itemstack == null || player == null) {
            return false;
        }
        return (Boolean)ItemConfig.magnetAllowInBaublesSlot.get() != false && ((Boolean)ItemConfig.magnetAllowDeactivatedInBaublesSlot.get() != false || ItemMagnet.isActive(itemstack));
    }

    @Optional.Method(modid="Baubles|API")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance.render(stack, xPosition, yPosition);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderUpgrade getRender(@Nonnull AbstractClientPlayer player) {
        return MagnetLayer.instance;
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return slotChanged ? super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) : oldStack.func_77973_b() != newStack.func_77973_b() || ItemMagnet.isActive(oldStack) != ItemMagnet.isActive(newStack);
    }
}

