/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.entity;

import com.google.common.base.Optional;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.machine.base.block.AbstractMachineBlock;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.machine.entity.RenderFallingMachine;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderio")
public class EntityFallingMachine
extends EntityFallingBlock {
    @Nonnull
    private static final DataParameter<Optional<IBlockState>> REAL_BLOCK = EntityDataManager.func_187226_a(EntityFallingMachine.class, (DataSerializer)DataSerializers.field_187197_g);
    @Nonnull
    private static final DataParameter<ItemStack> DROP_STACK = EntityDataManager.func_187226_a(EntityFallingMachine.class, (DataSerializer)DataSerializers.field_187196_f);
    protected IBlockState renderBS = null;

    @SubscribeEvent
    public static void onEntityRegister(RegistryEvent.Register<EntityEntry> event) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("enderio", "falling_machine"), EntityFallingMachine.class, (String)"enderio.falling_machine", (int)1, (Object)"enderio", (int)64, (int)100, (boolean)true);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPreInit(EnderIOLifecycleEvent.PreInit event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityFallingMachine.class, (IRenderFactory)RenderFallingMachine.FACTORY);
    }

    public EntityFallingMachine(World worldIn) {
        super(worldIn, 0.0, 0.0, 0.0, Blocks.field_192438_dM.func_176223_P());
    }

    public <T extends AbstractMachineEntity> EntityFallingMachine(@Nonnull WorldServer worldIn, @Nonnull BlockPos pos, @Nonnull Block block) {
        super((World)worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos));
        if (block instanceof AbstractMachineBlock) {
            ItemStack nbtDrop;
            AbstractMachineEntity te = (AbstractMachineEntity)AbstractMachineBlock.getAnyTileEntity((IBlockAccess)worldIn, (BlockPos)pos, (Class)((AbstractMachineBlock)block).getTeClass());
            if (te != null) {
                this.field_145810_d = te.func_189515_b(new NBTTagCompound());
            }
            if ((nbtDrop = ((AbstractMachineBlock)block).getNBTDrop((IBlockAccess)worldIn, pos, worldIn.func_180495_p(pos), 0, te)) != null) {
                this.setDropStack(nbtDrop);
            }
        } else {
            TileEntity te = (TileEntity)AbstractMachineBlock.getAnyTileEntity((IBlockAccess)worldIn, (BlockPos)pos, null);
            if (te != null) {
                this.field_145810_d = te.func_189515_b(new NBTTagCompound());
            }
            this.setDropStack(block.getPickBlock(worldIn.func_180495_p(pos), new RayTraceResult(new Vec3d(0.0, 0.0, 0.0), EnumFacing.DOWN, pos), (World)worldIn, pos, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)worldIn)));
        }
        this.func_145806_a(true);
        this.setRealBlockState(super.func_175131_l());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(REAL_BLOCK, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(DROP_STACK, (Object)ItemStack.field_190927_a);
    }

    public void func_70071_h_() {
        IBlockState blockState2;
        IBlockState blockState1;
        if (this.field_70170_p.field_72995_K && this.renderBS == null && (blockState1 = this.field_70170_p.func_180495_p(this.func_184531_j())).equals(blockState2 = this.getRealBlockState()) && blockState1.func_177230_c().hasTileEntity(blockState1)) {
            this.renderBS = blockState1.func_177230_c().getExtendedState(blockState1.func_177230_c().func_176221_a(this.field_70170_p.func_180495_p(this.func_184531_j()), (IBlockAccess)this.field_70170_p, this.func_184531_j()), (IBlockAccess)this.field_70170_p, this.func_184531_j());
        }
        if (super.func_175131_l() != null) {
            IBlockState fallTile = super.func_175131_l();
            Block block = fallTile.func_177230_c();
            if (fallTile.func_185904_a() == Material.field_151579_a) {
                this.func_70106_y();
            } else {
                this.field_70169_q = this.field_70165_t;
                this.field_70167_r = this.field_70163_u;
                this.field_70166_s = this.field_70161_v;
                if (this.field_145812_b++ == 0) {
                    BlockPos blockpos = new BlockPos((Entity)this);
                    if (this.field_70170_p.func_180495_p(blockpos).func_177230_c() == block) {
                        this.field_70170_p.func_175698_g(blockpos);
                    } else if (!this.field_70170_p.field_72995_K) {
                        this.func_70106_y();
                        return;
                    }
                }
                if (!this.func_189652_ae()) {
                    this.field_70181_x -= (double)0.04f;
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                if (!this.field_70170_p.field_72995_K) {
                    BlockPos blockpos1 = new BlockPos((Entity)this);
                    double d0 = this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y;
                    if (!this.field_70122_E) {
                        if (this.field_145812_b > 100 && !this.field_70170_p.field_72995_K && (blockpos1.func_177956_o() < 1 || blockpos1.func_177956_o() > 256) || this.field_145812_b > 600) {
                            if (this.field_145813_c && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                                this.func_70099_a(new ItemStack(block, 1, block.func_180651_a(fallTile)), 0.0f);
                            }
                            this.func_70106_y();
                        }
                    } else {
                        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos1);
                        if (this.field_70170_p.func_175623_d(new BlockPos(this.field_70165_t, this.field_70163_u - (double)0.01f, this.field_70161_v)) && BlockFalling.func_185759_i((IBlockState)this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - (double)0.01f, this.field_70161_v)))) {
                            this.field_70122_E = false;
                            return;
                        }
                        this.field_70159_w *= (double)0.7f;
                        this.field_70179_y *= (double)0.7f;
                        this.field_70181_x *= -0.5;
                        if (iblockstate.func_177230_c() != Blocks.field_180384_M) {
                            this.func_70106_y();
                            if (this.field_70170_p.func_190527_a(block, blockpos1, true, EnumFacing.UP, (Entity)this) && !BlockFalling.func_185759_i((IBlockState)this.field_70170_p.func_180495_p(blockpos1.func_177977_b())) && this.field_70170_p.func_180501_a(blockpos1, fallTile, 3)) {
                                TileEntity tileentity;
                                if (block instanceof BlockFalling) {
                                    ((BlockFalling)block).func_176502_a_(this.field_70170_p, blockpos1, fallTile, iblockstate);
                                }
                                if (this.field_145810_d != null && block.hasTileEntity(fallTile) && (tileentity = this.field_70170_p.func_175625_s(blockpos1)) != null) {
                                    NBTTagCompound nbttagcompound = new NBTTagCompound();
                                    nbttagcompound.func_74768_a("x", blockpos1.func_177958_n());
                                    nbttagcompound.func_74768_a("y", blockpos1.func_177956_o());
                                    nbttagcompound.func_74768_a("z", blockpos1.func_177952_p());
                                    for (String s : this.field_145810_d.func_150296_c()) {
                                        NBTBase nbtbase = this.field_145810_d.func_74781_a(s);
                                        if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                                        nbttagcompound.func_74782_a(s, nbtbase.func_74737_b());
                                    }
                                    tileentity.func_145839_a(nbttagcompound);
                                    tileentity.func_70296_d();
                                }
                            } else if (this.field_145813_c && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                                this.func_70099_a(new ItemStack(block, 1, block.func_180651_a(fallTile)), 0.0f);
                            } else if (block instanceof BlockFalling) {
                                ((BlockFalling)block).func_190974_b(this.field_70170_p, blockpos1);
                            }
                        }
                    }
                }
                this.field_70159_w *= (double)0.98f;
                this.field_70181_x *= (double)0.98f;
                this.field_70179_y *= (double)0.98f;
            }
        }
    }

    @Nullable
    public EntityItem func_70099_a(@Nonnull ItemStack stack, float offsetY) {
        if (Prep.isValid(this.getDropStack())) {
            return super.func_70099_a(this.getDropStack(), offsetY);
        }
        return super.func_70099_a(stack, offsetY);
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound tag = new NBTTagCompound();
        this.getDropStack().func_77955_b(tag);
        compound.func_74782_a("dropStack", (NBTBase)tag);
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRealBlockState(super.func_175131_l());
        this.setDropStack(new ItemStack(compound.func_74775_l("dropStack")));
    }

    @Nullable
    public IBlockState func_175131_l() {
        if (this.renderBS != null) {
            return this.renderBS;
        }
        IBlockState paint = PaintUtil.getSourceBlock(this.getDropStack());
        if (paint != null) {
            return paint;
        }
        IBlockState realBlockState = this.getRealBlockState();
        if (realBlockState != null) {
            return realBlockState;
        }
        return super.func_175131_l();
    }

    public void setRealBlockState(@Nullable IBlockState state) {
        this.field_70180_af.func_187227_b(REAL_BLOCK, (Object)Optional.fromNullable((Object)state));
    }

    @Nullable
    public IBlockState getRealBlockState() {
        return (IBlockState)((Optional)this.field_70180_af.func_187225_a(REAL_BLOCK)).orNull();
    }

    public void setDropStack(@Nonnull ItemStack stack) {
        this.field_70180_af.func_187227_b(DROP_STACK, (Object)stack);
    }

    @Nonnull
    public ItemStack getDropStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(DROP_STACK);
    }
}

