/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.glass;

import com.enderio.core.api.client.render.IWidgetIcon;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.lang.Lang;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IPassingCallback {
    @Nonnull
    public static final IPassingCallback NONE = new IPassingCallback(){

        @Override
        public boolean canPass(@Nonnull Entity entity) {
            return false;
        }
    };
    @Nonnull
    public static final IPassingCallback PLAYER = new IPassingCallback(){

        @Override
        public boolean canPass(@Nonnull Entity entity) {
            return entity instanceof EntityPlayer;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
            tooltip.add(Lang.BLOCK_ALLOW_PLAYERS.get());
        }

        @Override
        @Nullable
        public IWidgetIcon getIcon1() {
            return IconEIO.GLASS_PLAYER;
        }
    };
    @Nonnull
    public static final IPassingCallback MOB = new IPassingCallback(){

        @Override
        public boolean canPass(@Nonnull Entity entity) {
            return entity instanceof IMob;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
            tooltip.add(Lang.BLOCK_ALLOW_MONSTERS.get());
        }

        @Override
        @Nullable
        public IWidgetIcon getIcon1() {
            return IconEIO.GLASS_MONSTER;
        }
    };
    @Nonnull
    public static final IPassingCallback ANIMAL = new IPassingCallback(){

        @Override
        public boolean canPass(@Nonnull Entity entity) {
            return entity instanceof IAnimals && !(entity instanceof IMob);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
            tooltip.add(Lang.BLOCK_ALLOW_ANIMALS.get());
        }

        @Override
        @Nullable
        public IWidgetIcon getIcon1() {
            return IconEIO.GLASS_ANIMAL;
        }
    };
    @Nonnull
    public static final IPassingCallback NON_PLAYER = new IPassingCallback(){

        @Override
        public boolean canPass(@Nonnull Entity entity) {
            return !(entity instanceof EntityPlayer);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
            tooltip.add(Lang.BLOCK_DISALLOW_PLAYERS.get());
        }

        @Override
        @Nullable
        public IWidgetIcon getIcon1() {
            return IconEIO.GLASS_PLAYER;
        }

        @Override
        @Nullable
        public IWidgetIcon getIcon2() {
            return IconEIO.GLASS_NOT;
        }
    };
    @Nonnull
    public static final IPassingCallback NON_MOB = new IPassingCallback(){

        @Override
        public boolean canPass(@Nonnull Entity entity) {
            return !(entity instanceof IMob);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
            tooltip.add(Lang.BLOCK_DISALLOW_MONSTERS.get());
        }

        @Override
        @Nullable
        public IWidgetIcon getIcon1() {
            return IconEIO.GLASS_MONSTER;
        }

        @Override
        @Nullable
        public IWidgetIcon getIcon2() {
            return IconEIO.GLASS_NOT;
        }
    };
    @Nonnull
    public static final IPassingCallback NON_ANIMAL = new IPassingCallback(){

        @Override
        public boolean canPass(@Nonnull Entity entity) {
            return !(entity instanceof IAnimals) || entity instanceof IMob;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInformation(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
            tooltip.add(Lang.BLOCK_DISALLOW_ANIMALS.get());
        }

        @Override
        @Nullable
        public IWidgetIcon getIcon1() {
            return IconEIO.GLASS_ANIMAL;
        }

        @Override
        @Nullable
        public IWidgetIcon getIcon2() {
            return IconEIO.GLASS_NOT;
        }
    };

    public boolean canPass(@Nonnull Entity var1);

    @SideOnly(value=Side.CLIENT)
    default public void addInformation(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
    }

    @Nullable
    default public IWidgetIcon getIcon1() {
        return null;
    }

    @Nullable
    default public IWidgetIcon getIcon2() {
        return null;
    }
}

