/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.paint.render;

import crazypants.enderio.base.paint.IPaintable;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PaintHelper {
    @SideOnly(value=Side.CLIENT)
    private static TextureAtlasSprite lastTexture;
    @SideOnly(value=Side.CLIENT)
    private static final Random rand;

    @SideOnly(value=Side.CLIENT)
    public static boolean addHitEffects(@Nonnull IBlockState state, @Nonnull World world, @Nonnull RayTraceResult target, @Nonnull ParticleManager effectRenderer) {
        if (state.func_177230_c() instanceof IPaintable) {
            BlockPos pos = target.func_178782_a();
            IBlockState paintSource = ((IPaintable)state.func_177230_c()).getPaintSource(state, (IBlockAccess)world, pos);
            if (paintSource != null) {
                PaintHelper.addBlockHitEffects(world, state, paintSource, pos, target.field_178784_b, effectRenderer);
                lastTexture = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(paintSource);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void addBlockHitEffects(@Nonnull World world, @Nonnull IBlockState realBlock, @Nonnull IBlockState paintBlock, @Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nonnull ParticleManager effectRenderer) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        float f = 0.1f;
        AxisAlignedBB axisalignedbb = realBlock.func_185900_c((IBlockAccess)world, pos);
        double d0 = (double)i + rand.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72340_a;
        double d1 = (double)j + rand.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72338_b;
        double d2 = (double)k + rand.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)(f * 2.0f)) + (double)f + axisalignedbb.field_72339_c;
        switch (side) {
            case DOWN: {
                d1 = (double)j + axisalignedbb.field_72338_b - (double)f;
                break;
            }
            case UP: {
                d1 = (double)j + axisalignedbb.field_72337_e + (double)f;
                break;
            }
            case NORTH: {
                d2 = (double)k + axisalignedbb.field_72339_c - (double)f;
                break;
            }
            case SOUTH: {
                d2 = (double)k + axisalignedbb.field_72334_f + (double)f;
                break;
            }
            case WEST: {
                d0 = (double)i + axisalignedbb.field_72340_a - (double)f;
                break;
            }
            case EAST: {
                d0 = (double)i + axisalignedbb.field_72336_d + (double)f;
            }
        }
        Particle digFX = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), (double)i, (double)j, (double)k, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)paintBlock)});
        if (digFX instanceof ParticleDigging) {
            ((ParticleDigging)digFX).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f);
            if (paintBlock.func_177230_c() == Blocks.field_150349_c) {
                digFX.func_70538_b(0.6f, 0.6f, 0.6f);
            } else {
                int tint = Minecraft.func_71410_x().func_184125_al().func_186724_a(paintBlock, (IBlockAccess)world, pos, 0);
                float particleRed = 0.6f * (float)(tint >> 16 & 0xFF) / 255.0f;
                float particleGreen = 0.6f * (float)(tint >> 8 & 0xFF) / 255.0f;
                float particleBlue = 0.6f * (float)(tint & 0xFF) / 255.0f;
                digFX.func_70538_b(particleRed, particleGreen, particleBlue);
            }
            digFX.func_187109_b(d0, d1, d2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean addDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleManager effectRenderer) {
        IBlockState paintSource;
        TextureAtlasSprite texture = null;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IPaintable && (paintSource = ((IPaintable)state.func_177230_c()).getPaintSource(state, (IBlockAccess)world, pos)) != null) {
            texture = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(paintSource);
        }
        if (texture == null && (texture = lastTexture) == null) {
            return false;
        }
        int i = 4;
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < i; ++k) {
                for (int l = 0; l < i; ++l) {
                    double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / (double)i;
                    double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / (double)i;
                    double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / (double)i;
                    ParticleDigging fx = (ParticleDigging)new ParticleDigging.Factory().func_178902_a(-1, world, d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, new int[]{0});
                    fx.func_174846_a(pos);
                    fx.func_187117_a(texture);
                    effectRenderer.func_78873_a((Particle)fx);
                }
            }
        }
        return true;
    }

    static {
        rand = new Random();
    }
}

