/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import me.hypherionmc.simplerpclib.discordutils.RichPresenceCore;

public class FileWatcherService {
    private Thread thread;
    private WatchService watchService;
    private final String filePath;
    private final FileWatcherCallback callback;

    public FileWatcherService(String filePath, FileWatcherCallback serviceCallback) {
        this.filePath = filePath;
        this.callback = serviceCallback;
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            Path parent = new File(this.filePath).toPath().getParent();
            parent.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
            this.thread = new Thread(() -> {
                block5: while (true) {
                    WatchKey watchKey = null;
                    try {
                        WatchEvent<?> event;
                        Path changed;
                        watchKey = this.watchService.take();
                        Thread.sleep(500L);
                        Iterator<WatchEvent<?>> iterator = watchKey.pollEvents().iterator();
                        do {
                            if (!iterator.hasNext()) continue block5;
                        } while (!Files.exists(changed = parent.resolve((Path)(event = iterator.next()).context()), new LinkOption[0]) || !Files.isSameFile(changed, new File(this.filePath).toPath()));
                        this.callback.onConfigChanged();
                        continue;
                    }
                    catch (IOException | InterruptedException e) {
                        if (!(e instanceof InterruptedException)) {
                            e.printStackTrace();
                        }
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        if (watchKey == null) continue;
                        watchKey.reset();
                        continue;
                    }
                    break;
                }
            });
            this.thread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        this.thread.interrupt();
        try {
            this.watchService.close();
        }
        catch (IOException e) {
            RichPresenceCore.logger.info("Error closing watch service", e);
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    public static interface FileWatcherCallback {
        public void onConfigChanged();
    }
}

