/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.heatExchanger.block;

import nc.block.property.ISidedProperty;
import nc.block.property.PropertySidedEnum;
import nc.multiblock.heatExchanger.HeatExchangerTubeSetting;
import nc.multiblock.heatExchanger.HeatExchangerTubeType;
import nc.multiblock.heatExchanger.block.BlockHeatExchangerPartBase;
import nc.multiblock.heatExchanger.tile.TileHeatExchangerTube;
import nc.tile.internal.fluid.FluidConnection;
import nc.util.Lang;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockHeatExchangerTube
extends BlockHeatExchangerPartBase
implements ISidedProperty<HeatExchangerTubeSetting> {
    private static EnumFacing placementSide = null;
    private final HeatExchangerTubeType tubeType;
    private static final PropertySidedEnum<HeatExchangerTubeSetting> DOWN = PropertySidedEnum.create("down", HeatExchangerTubeSetting.class, EnumFacing.DOWN);
    private static final PropertySidedEnum<HeatExchangerTubeSetting> UP = PropertySidedEnum.create("up", HeatExchangerTubeSetting.class, EnumFacing.UP);
    private static final PropertySidedEnum<HeatExchangerTubeSetting> NORTH = PropertySidedEnum.create("north", HeatExchangerTubeSetting.class, EnumFacing.NORTH);
    private static final PropertySidedEnum<HeatExchangerTubeSetting> SOUTH = PropertySidedEnum.create("south", HeatExchangerTubeSetting.class, EnumFacing.SOUTH);
    private static final PropertySidedEnum<HeatExchangerTubeSetting> WEST = PropertySidedEnum.create("west", HeatExchangerTubeSetting.class, EnumFacing.WEST);
    private static final PropertySidedEnum<HeatExchangerTubeSetting> EAST = PropertySidedEnum.create("east", HeatExchangerTubeSetting.class, EnumFacing.EAST);

    public BlockHeatExchangerTube(HeatExchangerTubeType tubeType) {
        this.tubeType = tubeType;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        switch (this.tubeType) {
            case COPPER: {
                return new TileHeatExchangerTube.Copper();
            }
            case HARD_CARBON: {
                return new TileHeatExchangerTube.HardCarbon();
            }
            case THERMOCONDUCTING: {
                return new TileHeatExchangerTube.Thermoconducting();
            }
        }
        return null;
    }

    @Override
    public HeatExchangerTubeSetting getProperty(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        if (world.func_175625_s(pos) instanceof TileHeatExchangerTube) {
            return ((TileHeatExchangerTube)world.func_175625_s(pos)).getTubeSetting(facing);
        }
        return HeatExchangerTubeSetting.DISABLED;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a(DOWN, (Comparable)((Object)this.getProperty(world, pos, EnumFacing.DOWN))).func_177226_a(UP, (Comparable)((Object)this.getProperty(world, pos, EnumFacing.UP))).func_177226_a(NORTH, (Comparable)((Object)this.getProperty(world, pos, EnumFacing.NORTH))).func_177226_a(SOUTH, (Comparable)((Object)this.getProperty(world, pos, EnumFacing.SOUTH))).func_177226_a(WEST, (Comparable)((Object)this.getProperty(world, pos, EnumFacing.WEST))).func_177226_a(EAST, (Comparable)((Object)this.getProperty(world, pos, EnumFacing.EAST)));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND || player == null) {
            return false;
        }
        if (player.func_184614_ca().func_190926_b() && world.func_175625_s(pos) instanceof TileHeatExchangerTube) {
            TileHeatExchangerTube tube = (TileHeatExchangerTube)world.func_175625_s(pos);
            EnumFacing side = player.func_70093_af() ? facing.func_176734_d() : facing;
            tube.toggleTubeSetting(side);
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)BlockHeatExchangerTube.getToggleMessage(player, tube, side));
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    private static TextComponentString getToggleMessage(EntityPlayer player, TileHeatExchangerTube tube, EnumFacing side) {
        String message;
        HeatExchangerTubeSetting setting = tube.getTubeSetting(side);
        String string = message = player.func_70093_af() ? "nc.block.fluid_toggle_opposite" : "nc.block.fluid_toggle";
        TextFormatting color = setting == HeatExchangerTubeSetting.PRODUCT_OUT ? TextFormatting.LIGHT_PURPLE : (setting == HeatExchangerTubeSetting.INPUT_SPREAD ? TextFormatting.GREEN : (setting == HeatExchangerTubeSetting.DEFAULT ? TextFormatting.WHITE : TextFormatting.GRAY));
        return new TextComponentString(Lang.localise(message) + " " + color + Lang.localise("nc.block.exchanger_tube_fluid_side." + setting.func_176610_l()));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        placementSide = null;
        if (placer != null && placer.func_70093_af()) {
            placementSide = facing.func_176734_d();
        }
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placementSide == null) {
            return;
        }
        BlockPos from = pos.func_177972_a(placementSide);
        if (world.func_175625_s(pos) instanceof TileHeatExchangerTube && world.func_175625_s(from) instanceof TileHeatExchangerTube) {
            TileHeatExchangerTube tube = (TileHeatExchangerTube)world.func_175625_s(pos);
            TileHeatExchangerTube other = (TileHeatExchangerTube)world.func_175625_s(from);
            tube.setFluidConnections(FluidConnection.cloneArray(other.getFluidConnections()));
            tube.setTubeSettings((HeatExchangerTubeSetting[])other.getTubeSettings().clone());
            tube.markDirtyAndNotify();
        }
    }
}

