/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.internal.inventory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import nc.tile.internal.inventory.ItemSorption;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class InventoryConnection {
    @Nonnull
    private List<ItemSorption> sorptionList;
    @Nonnull
    private final List<ItemSorption> defaultSorptions;

    public InventoryConnection(@Nonnull List<ItemSorption> sorptionList) {
        this.sorptionList = new ArrayList<ItemSorption>(sorptionList);
        this.defaultSorptions = new ArrayList<ItemSorption>(sorptionList);
    }

    private InventoryConnection(@Nonnull InventoryConnection connection) {
        this.sorptionList = new ArrayList<ItemSorption>(connection.sorptionList);
        this.defaultSorptions = new ArrayList<ItemSorption>(connection.defaultSorptions);
    }

    private InventoryConnection copy() {
        return new InventoryConnection(this);
    }

    public static InventoryConnection[] cloneArray(@Nonnull InventoryConnection[] connections) {
        InventoryConnection[] clone = new InventoryConnection[6];
        for (int i = 0; i < 6; ++i) {
            clone[i] = connections[i].copy();
        }
        return clone;
    }

    public ItemSorption getItemSorption(int slot) {
        return this.sorptionList.get(slot);
    }

    public void setItemSorption(int slot, ItemSorption sorption) {
        this.sorptionList.set(slot, sorption);
    }

    public ItemSorption getDefaultItemSorption(int slot) {
        return this.defaultSorptions.get(slot);
    }

    public boolean canConnect() {
        for (ItemSorption sorption : this.sorptionList) {
            if (!sorption.canConnect()) continue;
            return true;
        }
        return false;
    }

    public int[] getSlotsForFace() {
        ArrayList<Integer> slotList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.sorptionList.size(); ++i2) {
            if (!this.getItemSorption(i2).canConnect()) continue;
            slotList.add(i2);
        }
        return slotList.stream().mapToInt(i -> i).toArray();
    }

    public void toggleItemSorption(int slot, ItemSorption.Type type, boolean reverse) {
        this.setItemSorption(slot, this.getItemSorption(slot).next(type, reverse));
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound nbt, @Nonnull EnumFacing side) {
        NBTTagCompound connectionTag = new NBTTagCompound();
        for (int i = 0; i < this.sorptionList.size(); ++i) {
            connectionTag.func_74768_a("sorption" + i, this.getItemSorption(i).ordinal());
        }
        nbt.func_74782_a("inventoryConnection" + side.func_176745_a(), (NBTBase)connectionTag);
        return nbt;
    }

    public final InventoryConnection readFromNBT(NBTTagCompound nbt, @Nonnull EnumFacing side) {
        if (nbt.func_74764_b("inventoryConnection" + side.func_176745_a())) {
            NBTTagCompound connectionTag = nbt.func_74775_l("inventoryConnection" + side.func_176745_a());
            for (int i = 0; i < this.sorptionList.size(); ++i) {
                if (!connectionTag.func_74764_b("sorption" + i)) continue;
                this.setItemSorption(i, ItemSorption.values()[connectionTag.func_74762_e("sorption" + i)]);
            }
        }
        return this;
    }
}

