/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.items.container;

import ic2.core.IC2;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.util.math.Box2D;
import ic2.core.util.misc.StackUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.gravisuit.GravisuitClassic;
import trinsdar.gravisuit.items.container.GuiRelocator;
import trinsdar.gravisuit.items.container.RelocatorButton;
import trinsdar.gravisuit.items.tools.ItemRelocator;
import trinsdar.gravisuit.network.PacketRelocator;

public class GuiCompRelocatorDisplay
extends GuiComponent {
    ItemStack relocator;
    EntityPlayer player;
    int y;
    String name;
    EnumHand hand;
    private Box2D BOX;

    public GuiCompRelocatorDisplay(EnumHand hand, int y, EntityPlayer player, String name) {
        super(new Box2D(3, 3 + y * 18, 170, 11));
        this.BOX = new Box2D(3, 3 + y * 18, 170, 11);
        this.relocator = player.func_184586_b(hand);
        this.hand = hand;
        this.y = 3 + y * 18;
        this.name = name;
        this.player = player;
    }

    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.GuiInit, GuiComponent.ActionRequest.ButtonNotify, GuiComponent.ActionRequest.ToolTip, GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.FrontgroundDraw);
    }

    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
        gui.registerButton((GuiButton)new RelocatorButton(2, this.bX(gui, 4), this.bY(gui, this.y + 1), 156, 9, false, false));
        gui.registerButton((GuiButton)new RelocatorButton(1, this.bX(gui, 163), this.bY(gui, this.y + 1), 9, 9, false, true));
    }

    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
        if (!(this.relocator.func_77973_b() instanceof ItemRelocator)) {
            return;
        }
        ItemRelocator item = (ItemRelocator)this.relocator.func_77973_b();
        if (button.field_146127_k == 2) {
            NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)this.relocator);
            int function = nbt.func_74771_c("TeleportMode") == 0 ? 3 : 2;
            ItemRelocator.TeleportData location = new ItemRelocator.TeleportData(this.name);
            GravisuitClassic.network.sendToServer((IMessage)new PacketRelocator(location, function, PacketRelocator.handToBool(this.hand)));
            if (function == 3) {
                this.player.func_71053_j();
            } else {
                IC2.platform.messagePlayer(this.player, this.name + " set as default");
            }
        }
        if (button.field_146127_k == 1) {
            ItemRelocator.TeleportData location = new ItemRelocator.TeleportData(this.name);
            GravisuitClassic.network.sendToServer((IMessage)new PacketRelocator(location, 1, PacketRelocator.handToBool(this.hand)));
            if (gui instanceof GuiRelocator) {
                ((GuiRelocator)gui).setReloadGui(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onToolTipCollecting(GuiIC2 gui, int mouseX, int mouseY, List<String> tooltips) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (GuiCompRelocatorDisplay.within(mouseY, 40, 56)) {
                // empty if block
            }
            if (GuiCompRelocatorDisplay.within(mouseY, 57, 72)) {
                // empty if block
            }
        }
    }

    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        NBTTagCompound map;
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        Box2D box = this.getPosition();
        NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)this.relocator);
        int textureY = 116;
        if (nbt.func_74779_i("DefaultLocation").equals(this.name)) {
            textureY = 155;
        }
        if ((map = nbt.func_74775_l("Locations")).func_74764_b(this.name)) {
            gui.func_73729_b(x + box.getX(), y + box.getY(), 0, textureY, box.getLenght(), box.getHeight());
        }
    }

    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        Box2D box = this.getPosition();
        NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)this.relocator);
        NBTTagCompound map = nbt.func_74775_l("Locations");
        if (map.func_74764_b(this.name)) {
            gui.drawString(this.name, 4, box.getY() + 2, Color.WHITE.getRGB());
        }
    }

    private int bX(GuiIC2 gui, int position) {
        return gui.getXOffset() + position;
    }

    private int bY(GuiIC2 gui, int position) {
        return gui.getYOffset() + position;
    }

    public static boolean within(int value, int low, int high) {
        return value >= low && value <= high;
    }
}

