/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy.wires.redstone;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.common.util.Utils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RedstoneWireNetwork {
    public byte[] channelValues = new byte[16];
    public List<WeakReference<IRedstoneConnector>> connectors = new ArrayList<WeakReference<IRedstoneConnector>>();

    public RedstoneWireNetwork add(IRedstoneConnector connector) {
        this.connectors.add(new WeakReference<IRedstoneConnector>(connector));
        return this;
    }

    public void mergeNetwork(RedstoneWireNetwork wireNetwork) {
        List<WeakReference<IRedstoneConnector>> conns = null;
        if (this.connectors.size() > 0) {
            conns = this.connectors;
        } else if (wireNetwork.connectors.size() > 0) {
            conns = wireNetwork.connectors;
        }
        if (conns == null) {
            return;
        }
        IRedstoneConnector start = null;
        for (WeakReference<IRedstoneConnector> conn : conns) {
            if (conn.get() == null) continue;
            start = (IRedstoneConnector)conn.get();
            break;
        }
        if (start != null) {
            BlockPos startPos = Utils.toCC(start);
            RedstoneWireNetwork.updateConnectors(startPos, start.getConnectorWorld(), this);
            this.updateValues();
        }
    }

    public void removeFromNetwork(IRedstoneConnector removedConnector) {
        Iterator<WeakReference<IRedstoneConnector>> iterator = this.connectors.iterator();
        HashSet<RedstoneWireNetwork> knownNets = new HashSet<RedstoneWireNetwork>();
        while (iterator.hasNext()) {
            WeakReference<IRedstoneConnector> conn = iterator.next();
            IRedstoneConnector start = (IRedstoneConnector)conn.get();
            if (start == null || knownNets.contains(start.getNetwork())) continue;
            RedstoneWireNetwork newNet = new RedstoneWireNetwork();
            RedstoneWireNetwork.updateConnectors(Utils.toCC(start), start.getConnectorWorld(), newNet);
            knownNets.add(newNet);
        }
    }

    public static void updateConnectors(BlockPos start, World world, RedstoneWireNetwork network) {
        int dimension = world.field_73011_w.getDimension();
        HashSet<BlockPos> open = new HashSet<BlockPos>();
        open.add(start);
        HashSet<BlockPos> closed = new HashSet<BlockPos>();
        network.connectors.clear();
        while (!open.isEmpty()) {
            Iterator it = open.iterator();
            BlockPos next = (BlockPos)it.next();
            it.remove();
            IImmersiveConnectable iic = ApiUtils.toIIC(next, world);
            closed.add(next);
            Set<ImmersiveNetHandler.Connection> connsAtBlock = ImmersiveNetHandler.INSTANCE.getConnections(dimension, next);
            if (iic instanceof IRedstoneConnector) {
                ((IRedstoneConnector)iic).setNetwork(network);
                network.connectors.add(new WeakReference<IRedstoneConnector>((IRedstoneConnector)iic));
            }
            if (connsAtBlock == null || iic == null) continue;
            for (ImmersiveNetHandler.Connection c : connsAtBlock) {
                if (!iic.allowEnergyToPass(c) || !"REDSTONE".equals(c.cableType.getCategory()) || closed.contains(c.end)) continue;
                open.add(c.end);
            }
        }
        network.channelValues = null;
        network.updateValues();
    }

    public void updateValues() {
        IRedstoneConnector connector;
        byte[] oldValues = this.channelValues;
        this.channelValues = new byte[16];
        for (WeakReference<IRedstoneConnector> connectorRef : this.connectors) {
            connector = (IRedstoneConnector)connectorRef.get();
            if (connector == null) continue;
            connector.updateInput(this.channelValues);
        }
        if (!Arrays.equals(oldValues, this.channelValues)) {
            for (WeakReference<IRedstoneConnector> connectorRef : this.connectors) {
                connector = (IRedstoneConnector)connectorRef.get();
                if (connector == null) continue;
                connector.onChange();
            }
        }
    }

    public int getPowerOutput(int redstoneChannel) {
        return this.channelValues[redstoneChannel];
    }

    public byte[] getByteValues() {
        byte[] values = new byte[16];
        for (int i = 0; i < values.length; ++i) {
            values[i] = (byte)(this.channelValues[i] * 16);
        }
        return values;
    }
}

