/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing.ast;

import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import info.openmods.calc.parsing.ast.IAstParser;
import info.openmods.calc.parsing.ast.IParserState;
import info.openmods.calc.parsing.token.Token;
import info.openmods.calc.parsing.token.TokenType;
import info.openmods.calc.parsing.token.TokenUtils;
import java.util.ArrayList;
import java.util.List;

public class QuotedParser<N>
implements IAstParser<N> {
    private final IQuotedExprNodeFactory<N> exprNodeFactory;

    public QuotedParser(IQuotedExprNodeFactory<N> exprNodeFactory) {
        this.exprNodeFactory = exprNodeFactory;
    }

    private N parseQuotedNode(PeekingIterator<Token> input) {
        Token token = (Token)input.next();
        if (token.type == TokenType.LEFT_BRACKET) {
            return this.parseNestedQuotedNode(token.value, input);
        }
        return this.exprNodeFactory.createValueNode(token);
    }

    private N parseNestedQuotedNode(String openingBracket, PeekingIterator<Token> input) {
        ArrayList children = Lists.newArrayList();
        while (true) {
            Token token = (Token)input.peek();
            if (token.type == TokenType.RIGHT_BRACKET) {
                TokenUtils.checkIsValidBracketPair(openingBracket, token.value);
                input.next();
                return this.exprNodeFactory.createBracketNode(openingBracket, token.value, children);
            }
            children.add(this.parseQuotedNode(input));
        }
    }

    @Override
    public N parse(IParserState<N> state, PeekingIterator<Token> input) {
        return this.parseQuotedNode(input);
    }

    public static interface IQuotedExprNodeFactory<E> {
        public E createValueNode(Token var1);

        public E createBracketNode(String var1, String var2, List<E> var3);
    }
}

