/*
 * Decompiled with CFR 0.152.
 */
package openmods.serializable.cls;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import net.minecraft.network.PacketBuffer;
import openmods.reflection.FieldAccess;
import openmods.reflection.TypeUtils;
import openmods.serializable.IObjectSerializer;
import openmods.serializable.SerializerRegistry;
import openmods.serializable.cls.Serialize;
import openmods.utils.bitstream.InputBitStream;
import openmods.utils.bitstream.OutputBitStream;
import openmods.utils.io.IStreamSerializer;
import openmods.utils.io.StreamAdapters;
import openmods.utils.io.StreamUtils;

public class ClassSerializerBuilder<T> {
    private final Class<? extends T> ownerClass;
    private final List<SerializableField> fields = Lists.newArrayList();
    private final Set<Field> addedFields = Sets.newHashSet();
    private int nullableCount = 0;

    public ClassSerializerBuilder(Class<? extends T> ownerClass) {
        this.ownerClass = ownerClass;
    }

    public void appendField(Field field) {
        boolean isNullable;
        Preconditions.checkArgument((boolean)field.getDeclaringClass().isAssignableFrom(this.ownerClass), (String)"%s does not belong to %s", (Object)field, this.ownerClass);
        boolean newlyAdded = this.addedFields.add(field);
        Preconditions.checkState((boolean)newlyAdded, (String)"%s already added", (Object)field);
        Serialize annotation = field.getAnnotation(Serialize.class);
        boolean bl = isNullable = !field.getType().isPrimitive() && annotation != null && annotation.nullable();
        if (isNullable) {
            ++this.nullableCount;
        }
        this.fields.add(new SerializableField(this.ownerClass, field, isNullable));
    }

    public IObjectSerializer<T> create() {
        return this.nullableCount != 0 ? new NullableSerializer(this.fields, StreamUtils.bitsToBytes(this.nullableCount)) : new NonNullableSerializer(this.fields);
    }

    private static class NullableSerializer<T>
    implements IObjectSerializer<T> {
        private final List<SerializableField> fields;
        private final int nullBytesCount;

        public NullableSerializer(List<SerializableField> fields, int nullBytesCount) {
            this.fields = ImmutableList.copyOf(fields);
            this.nullBytesCount = nullBytesCount;
        }

        @Override
        public void readFromStream(T object, PacketBuffer input) throws IOException {
            byte[] nullBits = StreamUtils.readBytes(input, this.nullBytesCount);
            InputBitStream nullBitStream = new InputBitStream(StreamAdapters.createSource(nullBits));
            for (SerializableField field : this.fields) {
                boolean isNull = field.isNullable && nullBitStream.readBit();
                Object value = isNull ? null : (Object)field.serializer.readFromStream(input);
                field.set(object, value);
            }
        }

        @Override
        public void writeToStream(T object, PacketBuffer output) throws IOException {
            OutputBitStream nullBitsStream = new OutputBitStream(StreamAdapters.createSink((ByteBuf)output));
            PacketBuffer payload = new PacketBuffer(Unpooled.buffer());
            for (SerializableField field : this.fields) {
                Object value = field.get(object);
                if (field.isNullable) {
                    if (value == null) {
                        nullBitsStream.writeBit(true);
                        continue;
                    }
                    nullBitsStream.writeBit(false);
                    field.serializer.writeToStream(value, payload);
                    continue;
                }
                field.serializer.writeToStream(value, payload);
            }
            nullBitsStream.flush();
            output.writeBytes((ByteBuf)payload);
        }
    }

    private static class NonNullableSerializer<T>
    implements IObjectSerializer<T> {
        private final List<SerializableField> fields;

        public NonNullableSerializer(List<SerializableField> fields) {
            this.fields = ImmutableList.copyOf(fields);
        }

        @Override
        public void readFromStream(T object, PacketBuffer input) throws IOException {
            for (SerializableField field : this.fields) {
                Object value = field.serializer.readFromStream(input);
                field.set(object, value);
            }
        }

        @Override
        public void writeToStream(T object, PacketBuffer output) throws IOException {
            for (SerializableField field : this.fields) {
                Object value = field.get(object);
                Preconditions.checkNotNull(value, (String)"Non-nullable %s has null value", (Object)field.field);
                field.serializer.writeToStream(value, output);
            }
        }
    }

    private static class SerializableField
    extends FieldAccess<Object> {
        private final IStreamSerializer<Object> serializer;
        private final boolean isNullable;

        public SerializableField(Class<?> ownerCls, Field field, boolean isNullable) {
            super(field);
            this.isNullable = isNullable;
            TypeToken<?> fieldType = TypeUtils.resolveFieldType(ownerCls, field);
            this.serializer = SerializerRegistry.instance.findSerializer(fieldType.getType());
            Preconditions.checkNotNull(this.serializer, (String)"Invalid field %s type", (Object)field);
        }
    }
}

