/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.commands;

import com.gmail.trentech.pjc.help.Help;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

public class CommandGamerule
implements CommandCallable {
    private final Help help = (Help)Help.get((String)"world gamerule").get();

    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        String value;
        String rule;
        String worldName;
        if (arguments.equalsIgnoreCase("gamerule")) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        String[] args = arguments.split(" ");
        if (args[args.length - 1].equalsIgnoreCase("--help")) {
            this.getHelp().execute(source);
            return CommandResult.success();
        }
        try {
            worldName = args[0];
        }
        catch (Exception e) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        Optional optionalProperties = Sponge.getServer().getWorldProperties(worldName);
        if (!optionalProperties.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, worldName, " does not exist"}), false);
        }
        WorldProperties properties = (WorldProperties)optionalProperties.get();
        try {
            rule = args[1];
            if (!this.validGamerule(properties, rule)) {
                source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, rule, " is not a valid Gamerule"}));
                throw new CommandException(this.getHelp().getUsageText());
            }
        }
        catch (Exception e) {
            ArrayList<Text> list = new ArrayList<Text>();
            for (Map.Entry gamerule : properties.getGameRules().entrySet()) {
                list.add(Text.of((Object[])new Object[]{TextColors.GREEN, gamerule.getKey(), ": ", TextColors.WHITE, gamerule.getValue()}));
            }
            if (source instanceof Player) {
                PaginationList.Builder pages = PaginationList.builder();
                pages.title(Text.builder().color(TextColors.DARK_GREEN).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, properties.getWorldName()})}).build());
                pages.contents(list);
                pages.sendTo((MessageReceiver)source);
            } else {
                for (Text text : list) {
                    source.sendMessage(text);
                }
            }
            return CommandResult.success();
        }
        try {
            value = args[2];
            if (!this.isValid(rule, value)) {
                source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, value, " is not a valid Value for Gamerule ", rule}));
                throw new CommandException(this.getHelp().getUsageText());
            }
        }
        catch (Exception e) {
            source.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, rule, ": ", TextColors.WHITE, properties.getGameRule(rule).get()}));
            return CommandResult.success();
        }
        properties.setGameRule(rule, value.toLowerCase());
        Sponge.getServer().saveWorldProperties(properties);
        source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Set gamerule ", rule, " to ", value}));
        return CommandResult.success();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, Location<World> targetPosition) throws CommandException {
        ArrayList<String> list = new ArrayList<String>();
        if (arguments.equalsIgnoreCase("gamerule")) {
            return list;
        }
        String[] args = arguments.split(" ");
        if (args.length == 1) {
            for (WorldProperties worldProperties : Sponge.getServer().getAllWorldProperties()) {
                if (worldProperties.getWorldName().equalsIgnoreCase(args[0])) {
                    for (Map.Entry entry : worldProperties.getGameRules().entrySet()) {
                        list.add((String)entry.getKey());
                    }
                    return list;
                }
                if (!worldProperties.getWorldName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(worldProperties.getWorldName());
            }
        }
        if (args.length == 2) {
            for (Map.Entry entry : ((WorldProperties)Sponge.getServer().getWorldProperties(args[0]).get()).getGameRules().entrySet()) {
                if (((String)entry.getKey()).toLowerCase().equalsIgnoreCase(args[1].toLowerCase())) {
                    return list;
                }
                if (!((String)entry.getKey()).toLowerCase().startsWith(args[1].toLowerCase())) continue;
                list.add((String)entry.getKey());
            }
        }
        return list;
    }

    public boolean testPermission(CommandSource source) {
        Optional permission = this.getHelp().getPermission();
        if (permission.isPresent()) {
            return source.hasPermission((String)permission.get());
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Text getUsage(CommandSource source) {
        return this.getHelp().getUsageText();
    }

    public Help getHelp() {
        return this.help;
    }

    private boolean isValid(String rule, String value) {
        switch (rule) {
            case "randomTickSpeed": {
                try {
                    Long.parseLong(value);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            case "spawnRadius": {
                try {
                    Long.parseLong(value);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            case "spawnOnDeath": {
                return Sponge.getServer().getWorld(value).isPresent() || rule.equals("default");
            }
            case "netherPortal": {
                return Sponge.getServer().getWorld(value).isPresent() || rule.equals("default");
            }
            case "endPortal": {
                return Sponge.getServer().getWorld(value).isPresent() || rule.equals("default");
            }
        }
        return this.validBool(value);
    }

    private boolean validBool(String value) {
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false");
    }

    private boolean validGamerule(WorldProperties properties, String rule) {
        for (Map.Entry entry : properties.getGameRules().entrySet()) {
            if (!((String)entry.getKey()).equals(rule)) continue;
            return true;
        }
        return false;
    }
}

