/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.commands;

import com.flowpowered.math.vector.Vector3i;
import com.gmail.trentech.pjc.help.Help;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

public class CommandSetSpawn
implements CommandCallable {
    private final Help help = (Help)Help.get((String)"world setspawn").get();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        Vector3i vector3i;
        WorldProperties properties;
        if (arguments.equalsIgnoreCase("setspawn")) {
            if (!(source instanceof Player)) {
                source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "Console must provide <world> and <x,y,z>"}));
                throw new CommandException(this.getHelp().getUsageText());
            }
            properties = ((Player)source).getWorld().getProperties();
            vector3i = ((Player)source).getLocation().getBlockPosition();
        } else {
            String[] args = arguments.split(" ");
            if (args[args.length - 1].equalsIgnoreCase("--help")) {
                this.getHelp().execute(source);
                return CommandResult.success();
            }
            try {
                String worldName = args[0];
                Optional optionalProperties = Sponge.getServer().getWorldProperties(worldName);
                if (!optionalProperties.isPresent()) {
                    throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, worldName, " does not exist"}), false);
                }
                properties = (WorldProperties)optionalProperties.get();
            }
            catch (Exception e) {
                if (!(source instanceof Player)) {
                    source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "Console must provide <world> and <x,y,z>"}));
                    throw new CommandException(this.getHelp().getUsageText());
                }
                properties = ((Player)source).getWorld().getProperties();
            }
            try {
                String coords = args[1];
                String[] coordinates = args[1].split(",");
                if (!this.isValidLocation(coordinates)) {
                    throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, coords.toString(), " is not valid"}), true);
                }
                vector3i = new Vector3i().add(Integer.parseInt(coordinates[0]), Integer.parseInt(coordinates[1]), Integer.parseInt(coordinates[2]));
            }
            catch (Exception e) {
                if (!(source instanceof Player)) {
                    source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "Console must provide <world> and <x,y,z>"}));
                    throw new CommandException(this.getHelp().getUsageText());
                }
                vector3i = ((Player)source).getLocation().getBlockPosition();
            }
        }
        properties.setSpawnPosition(vector3i);
        Sponge.getServer().saveWorldProperties(properties);
        source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Set spawn of world ", properties.getWorldName(), " to x: ", properties.getSpawnPosition().getX(), ", y: ", properties.getSpawnPosition().getY(), ", z: ", properties.getSpawnPosition().getZ()}));
        return CommandResult.success();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, Location<World> targetPosition) throws CommandException {
        ArrayList<String> list = new ArrayList<String>();
        if (arguments.equalsIgnoreCase("setspawn")) {
            return list;
        }
        for (WorldProperties world : Sponge.getServer().getAllWorldProperties()) {
            if (world.getWorldName().equalsIgnoreCase(arguments)) {
                return list;
            }
            if (!world.getWorldName().toLowerCase().startsWith(arguments.toLowerCase())) continue;
            list.add(world.getWorldName());
        }
        return list;
    }

    public boolean testPermission(CommandSource source) {
        Optional permission = this.getHelp().getPermission();
        if (permission.isPresent()) {
            return source.hasPermission((String)permission.get());
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Text getUsage(CommandSource source) {
        return this.getHelp().getUsageText();
    }

    public Help getHelp() {
        return this.help;
    }

    private boolean isValidLocation(String[] coords) {
        if (coords == null) {
            return false;
        }
        for (String coord : coords) {
            try {
                Integer.parseInt(coord);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

