/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.Localization;
import vswe.superfactory.components.CheckBox;
import vswe.superfactory.components.CheckBoxList;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.RadioButton;
import vswe.superfactory.components.RadioButtonList;
import vswe.superfactory.components.Variable;
import vswe.superfactory.components.VariableDisplay;
import vswe.superfactory.components.internal.ConnectionSet;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;

public class ComponentMenuVariable
extends ComponentMenu {
    private static final int CHECK_BOX_X = 5;
    private static final int CHECK_BOX_Y = 52;
    private static final String NBT_EXECUTED = "Executed";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_VARIABLE = "Variable";
    private static final int RADIO_BUTTON_SPACING = 12;
    private static final int RADIO_BUTTON_X = 5;
    private static final int RADIO_BUTTON_Y = 28;
    private CheckBoxList checkBoxes;
    private boolean executed;
    private RadioButtonList radioButtons;
    private int selectedVariable = 0;
    private VariableDisplay varDisplay;

    public ComponentMenuVariable(FlowComponent parent) {
        super(parent);
        int declarationCount = 0;
        int modificationCount = 0;
        this.radioButtons = new RadioButtonList(){

            @Override
            public int getSelectedOption() {
                int id = super.getSelectedOption();
                VariableMode mode = VariableMode.values()[id];
                if (mode.declaration != ComponentMenuVariable.this.isDeclaration()) {
                    id = ComponentMenuVariable.this.getDefaultId();
                    this.setSelectedOption(id);
                }
                return id;
            }

            @Override
            public void setSelectedOption(int selectedOption) {
                super.setSelectedOption(selectedOption);
                if (ComponentMenuVariable.this.isDeclaration()) {
                    ComponentMenuVariable.this.getParent().getManager().updateVariables();
                }
            }

            @Override
            public void updateSelectedOption(int selectedOption) {
                this.setSelectedOption(selectedOption);
                DataWriter dw = ComponentMenuVariable.this.getWriterForServerComponentPacket();
                dw.writeBoolean(true);
                dw.writeBoolean(false);
                dw.writeData(selectedOption, DataBitHelper.CONTAINER_MODE);
                PacketHandler.sendDataToServer(dw);
            }
        };
        for (int i = 0; i < VariableMode.values().length; ++i) {
            final VariableMode mode = VariableMode.values()[i];
            int id = mode.declaration ? declarationCount++ : modificationCount++;
            this.radioButtons.add(new RadioButton(5, 28 + id * 12, mode.getName()){

                @Override
                public boolean isVisible() {
                    return mode.declaration == ComponentMenuVariable.this.isDeclaration();
                }
            });
        }
        this.radioButtons.setSelectedOption(this.getDefaultId());
        this.varDisplay = new VariableDisplay(null, 5, 5){

            @Override
            public int getValue() {
                return ComponentMenuVariable.this.selectedVariable;
            }

            @Override
            public void setValue(int val) {
                ComponentMenuVariable.this.setSelectedVariable(val);
            }

            @Override
            public void onUpdate() {
                DataWriter dw = ComponentMenuVariable.this.getWriterForServerComponentPacket();
                dw.writeBoolean(true);
                dw.writeBoolean(true);
                dw.writeData(ComponentMenuVariable.this.selectedVariable, DataBitHelper.VARIABLE_TYPE);
                PacketHandler.sendDataToServer(dw);
            }
        };
        this.checkBoxes = new CheckBoxList();
        this.checkBoxes.addCheckBox(new CheckBox(Localization.GLOBAL_VALUE_SET, 5, 52){

            @Override
            public boolean getValue() {
                return ComponentMenuVariable.this.executed;
            }

            @Override
            public void setValue(boolean val) {
                ComponentMenuVariable.this.executed = val;
            }

            @Override
            public void onUpdate() {
                DataWriter dw = ComponentMenuVariable.this.getWriterForServerComponentPacket();
                dw.writeBoolean(false);
                dw.writeBoolean(ComponentMenuVariable.this.executed);
                PacketHandler.sendDataToServer(dw);
            }

            @Override
            public boolean isVisible() {
                return ComponentMenuVariable.this.getVariableMode() == VariableMode.GLOBAL;
            }
        });
    }

    public boolean isDeclaration() {
        return this.getParent().getConnectionSet() == ConnectionSet.EMPTY;
    }

    private int getDefaultId() {
        return this.isDeclaration() ? 1 : 2;
    }

    public VariableMode getVariableMode() {
        return VariableMode.values()[this.radioButtons.getSelectedOption()];
    }

    @Override
    public String getName() {
        return Localization.VARIABLE_MENU.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        this.radioButtons.draw(gui, mX, mY);
        this.varDisplay.draw(gui, mX, mY);
        this.checkBoxes.draw(gui, mX, mY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
        this.varDisplay.drawMouseOver(gui, mX, mY);
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        this.radioButtons.onClick(mX, mY, button);
        this.varDisplay.onClick(mX, mY);
        this.checkBoxes.onClick(mX, mY);
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeData(this.selectedVariable, DataBitHelper.VARIABLE_TYPE);
        dw.writeData(this.radioButtons.getSelectedOption(), DataBitHelper.CONTAINER_MODE);
        dw.writeBoolean(this.executed);
    }

    @Override
    public void readData(DataReader dr) {
        this.setSelectedVariable(dr.readData(DataBitHelper.VARIABLE_TYPE));
        this.radioButtons.setSelectedOption(dr.readData(DataBitHelper.CONTAINER_MODE));
        this.executed = dr.readBoolean();
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        this.setSelectedVariable(((ComponentMenuVariable)menu).selectedVariable);
        this.radioButtons.setSelectedOption(((ComponentMenuVariable)menu).radioButtons.getSelectedOption());
        this.executed = ((ComponentMenuVariable)menu).executed;
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        DataWriter dw;
        ComponentMenuVariable newDataMode = (ComponentMenuVariable)newData;
        if (this.selectedVariable != newDataMode.selectedVariable) {
            this.setSelectedVariable(newDataMode.selectedVariable);
            dw = this.getWriterForClientComponentPacket(container);
            dw.writeBoolean(true);
            dw.writeBoolean(true);
            dw.writeData(this.selectedVariable, DataBitHelper.VARIABLE_TYPE);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
        if (this.radioButtons.getRawSelectedOption() != newDataMode.radioButtons.getRawSelectedOption()) {
            this.radioButtons.setSelectedOption(newDataMode.radioButtons.getRawSelectedOption());
            dw = this.getWriterForClientComponentPacket(container);
            dw.writeBoolean(true);
            dw.writeBoolean(false);
            dw.writeData(this.radioButtons.getRawSelectedOption(), DataBitHelper.CONTAINER_MODE);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
        if (this.executed != newDataMode.getVariable().hasBeenExecuted()) {
            this.executed = newDataMode.getVariable().hasBeenExecuted();
            dw = this.getWriterForClientComponentPacket(container);
            dw.writeBoolean(false);
            dw.writeBoolean(this.executed);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
    }

    private Variable getVariable() {
        return this.getParent().getManager().getVariables()[this.getSelectedVariable()];
    }

    public int getSelectedVariable() {
        return this.selectedVariable;
    }

    private void setSelectedVariable(int val) {
        this.selectedVariable = val;
        if (this.isDeclaration()) {
            this.getParent().getManager().updateVariables();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        this.setSelectedVariable(nbtTagCompound.func_74771_c(NBT_VARIABLE));
        this.radioButtons.setSelectedOption(nbtTagCompound.func_74771_c(NBT_MODE));
        this.executed = nbtTagCompound.func_74767_n(NBT_EXECUTED);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74774_a(NBT_VARIABLE, (byte)this.selectedVariable);
        nbtTagCompound.func_74774_a(NBT_MODE, (byte)this.radioButtons.getSelectedOption());
        nbtTagCompound.func_74757_a(NBT_EXECUTED, this.executed);
    }

    @Override
    public void addErrors(List<String> errors) {
        Variable variable = this.getParent().getManager().getVariables()[this.selectedVariable];
        if (!variable.isValid()) {
            errors.add(Localization.NOT_DECLARED_ERROR.toString());
        } else if (this.isDeclaration() && variable.getDeclaration().getId() != this.getParent().getId()) {
            errors.add(Localization.ALREADY_DECLARED_ERROR.toString());
        }
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        if (dr.readBoolean()) {
            if (dr.readBoolean()) {
                this.setSelectedVariable(dr.readData(DataBitHelper.VARIABLE_TYPE));
            } else {
                this.radioButtons.setSelectedOption(dr.readData(DataBitHelper.CONTAINER_MODE));
            }
        } else {
            this.executed = dr.readBoolean();
            if (!this.getParent().getManager().func_145831_w().field_72995_K) {
                this.getVariable().setExecuted(this.executed);
            }
        }
    }

    public static enum VariableMode {
        GLOBAL(Localization.GLOBAL, true),
        LOCAL(Localization.LOCAL, true),
        ADD(Localization.ADD, false),
        REMOVE(Localization.REMOVE, false),
        SET(Localization.SET, false);

        private boolean declaration;
        private Localization name;

        private VariableMode(Localization name, boolean declaration) {
            this.name = name;
            this.declaration = declaration;
        }

        public Localization getName() {
            return this.name;
        }

        public String toString() {
            return super.toString().charAt(0) + super.toString().substring(1).toLowerCase();
        }
    }
}

