/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.util;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import mezz.jei.plugins.jei.JEIInternalPlugin;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class SearchUtil {
    private static final Multimap<ItemStack, String> cache = Multimaps.synchronizedListMultimap((ListMultimap)LinkedListMultimap.create());
    private static final List<Query> queries = new ArrayList<Query>();
    protected static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    public static void buildCache() {
        new Thread(() -> {
            long time_no_see = System.currentTimeMillis();
            try {
                NonNullList stacks = NonNullList.func_191196_a();
                if (Loader.isModLoaded((String)"jei") && JEIInternalPlugin.ingredientRegistry != null) {
                    stacks.addAll(JEIInternalPlugin.ingredientRegistry.getAllIngredients(ItemStack.class));
                } else {
                    StreamSupport.stream(Item.field_150901_e.spliterator(), false).filter(Objects::nonNull).filter(i -> i.func_77640_w() != null).forEach(i -> {
                        try {
                            i.func_150895_a(CreativeTabs.field_78027_g, stacks);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
                if (Launch.blackboard.get("fml.deobfuscatedEnvironment") != null) {
                    ListIterator iter = stacks.listIterator();
                    while (stacks.size() < 100000) {
                        stacks.add(iter.next());
                    }
                }
                cache.clear();
                stacks.stream().filter(Objects::nonNull).filter(itemStack -> !itemStack.func_190926_b()).sorted(Comparator.comparingInt(s -> s.func_77973_b().getRegistryName() != null && s.func_77973_b().getRegistryName().func_110624_b().equals("minecraft") ? 0 : 1).thenComparingInt(s -> s.func_82833_r().length()).thenComparing(ItemStack::func_82833_r)).forEach(stack -> {
                    try {
                        cache.put(stack, (Object)stack.func_82833_r());
                        cache.put(stack, (Object)SearchUtil.getTooltip(stack, null));
                        int[] oreDict = OreDictionary.getOreIDs((ItemStack)stack);
                        for (int i = 0; i < oreDict.length; ++i) {
                            cache.put(stack, (Object)OreDictionary.getOreName((int)oreDict[i]));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                System.out.println("[SFM] Indexed " + stacks.size() + " items in " + (System.currentTimeMillis() - time_no_see) + "ms.");
            }
            catch (Exception ignored) {
                cache.put((Object)ItemStack.field_190927_a, (Object)"");
            }
        }).start();
    }

    public static Multimap<ItemStack, String> getCache() {
        return cache;
    }

    @SideOnly(value=Side.CLIENT)
    public static List<ItemStack> getSearchResults(String search, boolean showAll) {
        queries.forEach(Query::stop);
        queries.clear();
        NonNullList results = NonNullList.func_191196_a();
        if (search.equals(".inv")) {
            InventoryPlayer inventory = Minecraft.func_71410_x().field_71439_g.field_71071_by;
            IntStream.range(0, inventory.func_70302_i_()).mapToObj(arg_0 -> ((IInventory)inventory).func_70301_a(arg_0)).filter(s -> !s.func_190926_b()).map(s -> ItemHandlerHelper.copyStackWithSize((ItemStack)s, (int)1)).forEach(s -> {
                if (results.stream().noneMatch(r -> ItemStack.func_77989_b((ItemStack)s, (ItemStack)r))) {
                    results.add(s);
                }
            });
        } else if (showAll || search.length() == 0) {
            results.addAll((Collection)SearchUtil.getCache().keySet());
        } else {
            queries.add(new Query(search, (List<ItemStack>)results));
        }
        return results;
    }

    @SideOnly(value=Side.CLIENT)
    public static String getTooltip(ItemStack stack, @Nullable EntityPlayer playerIn) {
        NBTTagList nbttaglist2;
        NBTTagList nbttaglist1;
        StringBuilder list = new StringBuilder();
        String s = stack.func_82833_r();
        String s1 = "";
        if (!s.isEmpty()) {
            s = s + " (";
            s1 = ")";
        }
        int i = Item.func_150891_b((Item)stack.func_77973_b());
        s = stack.func_77981_g() ? s + String.format("#%04d/%d%s", i, stack.func_77952_i(), s1) : s + String.format("#%04d%s", i, s1);
        list.append(s);
        ArrayList<String> asd = new ArrayList<String>();
        stack.func_77973_b().func_77624_a(stack, playerIn == null ? null : playerIn.field_70170_p, asd, (ITooltipFlag)ITooltipFlag.TooltipFlags.ADVANCED);
        asd.forEach(list::append);
        if (stack.func_77942_o()) {
            NBTTagList nbttaglist3;
            NBTTagCompound nbttagcompound1;
            NBTTagList nbttaglist = stack.func_77986_q();
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(j);
                short k = nbttagcompound.func_74765_d("id");
                short l = nbttagcompound.func_74765_d("lvl");
                Enchantment enchantment = Enchantment.func_185262_c((int)k);
                if (enchantment == null) continue;
                list.append(enchantment.func_77316_c((int)l));
            }
            if (stack.func_77978_p().func_150297_b("display", 10) && (nbttagcompound1 = stack.func_77978_p().func_74775_l("display")).func_150299_b("Lore") == 9 && !(nbttaglist3 = nbttagcompound1.func_150295_c("Lore", 8)).func_82582_d()) {
                for (int l1 = 0; l1 < nbttaglist3.func_74745_c(); ++l1) {
                    list.append(nbttaglist3.func_150307_f(l1));
                }
            }
        }
        for (NBTTagList entityequipmentslot : EntityEquipmentSlot.values()) {
            Multimap multimap = stack.func_111283_C((EntityEquipmentSlot)entityequipmentslot);
            if (multimap.isEmpty()) continue;
            list.append(I18n.func_74838_a((String)("item.modifiers." + entityequipmentslot.func_188450_d())));
            for (Map.Entry entry : multimap.entries()) {
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                double d0 = attributemodifier.func_111164_d();
                boolean flag = false;
                if (playerIn != null) {
                    if (attributemodifier.func_111167_a() == ATTACK_DAMAGE_MODIFIER) {
                        d0 += playerIn.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
                        d0 += (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
                        flag = true;
                    } else if (attributemodifier.func_111167_a() == ATTACK_SPEED_MODIFIER) {
                        d0 += playerIn.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b();
                        flag = true;
                    }
                }
                double d1 = attributemodifier.func_111169_c() != 1 && attributemodifier.func_111169_c() != 2 ? d0 : d0 * 100.0;
                if (flag) {
                    list.append(I18n.func_74837_a((String)("attribute.modifier.equals." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), I18n.func_74838_a((String)("attribute.name." + (String)entry.getKey()))}));
                    continue;
                }
                if (d0 > 0.0) {
                    list.append(I18n.func_74837_a((String)("attribute.modifier.plus." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), I18n.func_74838_a((String)("attribute.name." + (String)entry.getKey()))}));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                list.append(I18n.func_74837_a((String)("attribute.modifier.take." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), I18n.func_74838_a((String)("attribute.name." + (String)entry.getKey()))}));
            }
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("Unbreakable")) {
            list.append(I18n.func_74838_a((String)"item.unbreakable"));
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("CanDestroy", 9) && !(nbttaglist1 = stack.func_77978_p().func_150295_c("CanDestroy", 8)).func_82582_d()) {
            list.append(I18n.func_74838_a((String)"item.canBreak"));
            for (int j1 = 0; j1 < nbttaglist1.func_74745_c(); ++j1) {
                Block block = Block.func_149684_b((String)nbttaglist1.func_150307_f(j1));
                if (block != null) {
                    list.append(block.func_149732_F());
                    continue;
                }
                list.append("missingno");
            }
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("CanPlaceOn", 9) && !(nbttaglist2 = stack.func_77978_p().func_150295_c("CanPlaceOn", 8)).func_82582_d()) {
            list.append(I18n.func_74838_a((String)"item.canPlace"));
            for (int k1 = 0; k1 < nbttaglist2.func_74745_c(); ++k1) {
                Block block1 = Block.func_149684_b((String)nbttaglist2.func_150307_f(k1));
                if (block1 != null) {
                    list.append(block1.func_149732_F());
                    continue;
                }
                list.append("missingno");
            }
        }
        if (stack.func_77951_h()) {
            list.append(I18n.func_74837_a((String)"item.durability", (Object[])new Object[]{stack.func_77958_k() - stack.func_77952_i(), stack.func_77958_k()}));
        }
        list.append(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString());
        if (stack.func_77942_o()) {
            list.append(I18n.func_74837_a((String)"item.nbt_tags", (Object[])new Object[]{stack.func_77978_p().func_150296_c().size()}));
        }
        return list.toString();
    }

    private static class Query {
        private volatile boolean running = true;

        public Query(String search, List<ItemStack> results) {
            new Thread(() -> {
                Pattern p;
                try {
                    p = Pattern.compile(search, 2);
                }
                catch (PatternSyntaxException e) {
                    p = Pattern.compile(Pattern.quote(search), 2);
                }
                Pattern pattern = p;
                Iterator iter = SearchUtil.getCache().entries().iterator();
                while (iter.hasNext() && this.running) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    if (!pattern.matcher((CharSequence)entry.getValue()).find() || results.contains(entry.getKey())) continue;
                    results.add((ItemStack)entry.getKey());
                }
            }).start();
        }

        public void stop() {
            this.running = false;
        }
    }
}

