/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.repackage.buildcraft.lib.expression;

import java.util.function.Consumer;

public class ExpressionDebugManager {
    public static boolean debug = false;
    public static Consumer<String> logger = System.out::println;
    private static String debugIndentCache = "";

    public static void debugStart(String text) {
        if (debug) {
            ExpressionDebugManager.debugPrintln(text);
            debugIndentCache = debugIndentCache + "  ";
        }
    }

    public static void debugEnd(String text) {
        if (debug) {
            if (debugIndentCache.length() > 1) {
                debugIndentCache = debugIndentCache.substring(2);
            } else if (debugIndentCache.length() > 0) {
                debugIndentCache = "";
            }
            ExpressionDebugManager.debugPrintln(text);
        }
    }

    public static void debugPrintln(String text) {
        if (debug) {
            logger.accept(debugIndentCache + text);
        }
    }

    public static void debugNodeClass(Class<?> clazz) {
        if (debug) {
            ExpressionDebugManager.debugPrintln("Unknown node class detected!");
            ExpressionDebugManager.debugNodeClass0(clazz, " ", true);
        }
    }

    private static void debugNodeClass0(Class<?> clazz, String indent, boolean isBase) {
        if (clazz == null) {
            return;
        }
        String before = isBase ? "" : (clazz.isInterface() ? "implements " : "extends ");
        ExpressionDebugManager.debugPrintln(indent + before + clazz.getName());
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != Object.class) {
            ExpressionDebugManager.debugNodeClass0(superClazz, indent + " ", false);
        }
        for (Class<?> inter : clazz.getInterfaces()) {
            ExpressionDebugManager.debugNodeClass0(inter, indent + " ", false);
        }
    }
}

