/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.gameobject;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidIdentity {
    public static final FluidIdentity EMPTY = new FluidIdentity((String)null);
    @Nullable
    private final String fluidName;
    @Nullable
    private final NBTTagCompound dataTag;

    public static FluidIdentity getForStack(@Nullable FluidStack stack) {
        return stack == null || stack.amount <= 0 ? EMPTY : new FluidIdentity(stack.getFluid(), stack.tag);
    }

    public FluidIdentity(@Nullable String fluidName, @Nullable NBTTagCompound dataTag) {
        this.fluidName = fluidName;
        this.dataTag = dataTag;
    }

    public FluidIdentity(@Nullable Fluid fluid, @Nullable NBTTagCompound dataTag) {
        this(fluid != null ? fluid.getName() : null, dataTag);
    }

    public FluidIdentity(@Nullable String fluidName) {
        this(fluidName, null);
    }

    public FluidIdentity(@Nullable Fluid fluid) {
        this(fluid != null ? fluid.getName() : null);
    }

    @Nullable
    public String getFluidName() {
        return this.fluidName;
    }

    @Nullable
    public Fluid getFluid() {
        return this.fluidName != null ? FluidRegistry.getFluid((String)this.fluidName) : null;
    }

    @Nullable
    public NBTTagCompound getDataTag() {
        return this.dataTag != null ? this.dataTag.func_74737_b() : null;
    }

    public boolean isEmpty() {
        return this.fluidName == null;
    }

    @Nullable
    public FluidStack createStack(int amount) {
        if (amount <= 0 || this.fluidName == null) {
            return null;
        }
        return new FluidStack(Objects.requireNonNull(this.getFluid()), amount, this.dataTag);
    }

    public boolean matches(@Nullable FluidStack stack) {
        if (this.fluidName == null) {
            return stack == null || stack.amount <= 0;
        }
        if (stack == null || stack.amount <= 0) {
            return false;
        }
        return stack.getFluid().getName().equals(this.fluidName) && Objects.equals(this.dataTag, stack.tag);
    }

    public int hashCode() {
        if (this.fluidName == null) {
            return 0;
        }
        return this.fluidName.hashCode() * 523 ^ (this.dataTag == null ? -559038737 : this.dataTag.hashCode());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FluidIdentity)) {
            return false;
        }
        FluidIdentity o = (FluidIdentity)obj;
        if (this.fluidName == null) {
            return o.fluidName == null;
        }
        return this.fluidName.equals(o.fluidName) && Objects.equals(this.dataTag, o.dataTag);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fluidName);
        if (this.dataTag != null) {
            sb.append(" ").append(this.dataTag);
        }
        return sb.toString();
    }
}

