/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import paulevs.betternether.BetterNether;

public class BlockNetherCactus
extends Block {
    public static final PropertyEnum<EnumShape> SHAPE = PropertyEnum.func_177709_a((String)"shape", EnumShape.class);
    private static final AxisAlignedBB TOP_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    private static final AxisAlignedBB SIDE_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875);

    public BlockNetherCactus() {
        super(Material.field_151570_A, MapColor.field_193562_N);
        this.func_149647_a(BetterNether.BN_TAB);
        this.setRegistryName("nether_cactus");
        this.func_149663_c("nether_cactus");
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SHAPE, (Comparable)((Object)EnumShape.TOP)));
        this.func_149672_a(SoundType.field_185854_g);
    }

    public IBlockState func_176203_a(int meta) {
        EnumShape shape = EnumShape.TOP;
        if (meta == 1) {
            shape = EnumShape.SIDE;
        }
        return this.func_176223_P().func_177226_a(SHAPE, (Comparable)((Object)shape));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumShape)((Object)state.func_177229_b(SHAPE))).getIndex();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SHAPE});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ((EnumShape)((Object)state.func_177229_b(SHAPE))).getIndex() == 0 ? TOP_AABB : SIDE_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.canStay(worldIn, pos)) {
            if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
                worldIn.func_175656_a(pos, state.func_177226_a(SHAPE, (Comparable)((Object)EnumShape.TOP)));
            } else {
                worldIn.func_175656_a(pos, state.func_177226_a(SHAPE, (Comparable)((Object)EnumShape.SIDE)));
            }
        }
    }

    private boolean canStay(World worldIn, BlockPos pos) {
        Block under = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (under != this && under != Blocks.field_150351_n) {
            worldIn.func_175655_b(pos, true);
            return false;
        }
        return true;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        IBlockState normal = this.func_176223_P().func_177226_a(SHAPE, (Comparable)((Object)EnumShape.SIDE));
        if (this.canStay(worldIn, pos) && worldIn.func_175623_d(pos.func_177984_a())) {
            int i = 1;
            while (worldIn.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            if (i < 3 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
                if (rand.nextInt(16) == 0) {
                    worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                    worldIn.func_180501_a(pos, normal, 2);
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        Block under = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        return under == this || under == Blocks.field_150351_n;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.func_70097_a(DamageSource.field_76367_g, 1.5f);
    }

    public static enum EnumShape implements IStringSerializable
    {
        TOP(0, "top"),
        SIDE(1, "side");

        private final String name;
        private final int index;

        private EnumShape(int index, String name) {
            this.name = name;
            this.index = index;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

