/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.manasteel;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISortableTool;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.client.render.IModelRegister;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemManasteelAxe
extends ItemAxe
implements IManaUsingItem,
ISortableTool,
IModelRegister {
    private static final Pattern SAPLING_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)sapling)|(?:(?:[a-z-_.:]|^)Sapling))(?:[A-Z-_.:]|$)");
    private static final int MANA_PER_DAMAGE = 60;

    public ItemManasteelAxe() {
        this(BotaniaAPI.manasteelToolMaterial, "manasteelAxe");
    }

    public ItemManasteelAxe(Item.ToolMaterial mat, String name) {
        super(mat, 8.0f, -3.1f);
        this.func_77637_a(BotaniaCreativeTab.INSTANCE);
        this.setRegistryName(new ResourceLocation("botania", name));
        this.func_77655_b(name);
    }

    @Nonnull
    public String func_77657_g(@Nonnull ItemStack par1ItemStack) {
        return super.func_77657_g(par1ItemStack).replaceAll("item.", "item.botania:");
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, @Nonnull EntityLivingBase par3EntityLivingBase) {
        ToolCommons.damageItem(par1ItemStack, 1, par3EntityLivingBase, this.getManaPerDamage());
        return true;
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity) {
        if (state.func_185887_b(world, pos) != 0.0f) {
            ToolCommons.damageItem(stack, 1, entity, this.getManaPerDamage());
        }
        return true;
    }

    public int getManaPerDamage() {
        return 60;
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float sx, float sy, float sz) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stackAt = player.field_71071_by.func_70301_a(i);
            if (stackAt.func_190926_b() || !SAPLING_PATTERN.matcher(stackAt.func_77973_b().func_77658_a()).find()) continue;
            ItemStack saveHeldStack = player.func_184586_b(hand);
            player.func_184611_a(hand, stackAt);
            EnumActionResult did = stackAt.func_77973_b().func_180614_a(player, world, pos, hand, side, sx, sy, sz);
            player.func_184611_a(hand, saveHeldStack);
            ItemsRemainingRenderHandler.set(player, new ItemStack(Blocks.field_150345_g), SAPLING_PATTERN);
            return did;
        }
        return EnumActionResult.PASS;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        if (!world.field_72995_K && player instanceof EntityPlayer && stack.func_77952_i() > 0 && ManaItemHandler.requestManaExactForTool(stack, (EntityPlayer)player, this.getManaPerDamage() * 2, true)) {
            stack.func_77964_b(stack.func_77952_i() - 1);
        }
    }

    public boolean func_82789_a(ItemStack par1ItemStack, @Nonnull ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == ModItems.manaResource && par2ItemStack.func_77952_i() == 0 ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public ISortableTool.ToolType getSortingType(ItemStack stack) {
        return ISortableTool.ToolType.AXE;
    }

    @Override
    public int getSortingPriority(ItemStack stack) {
        return ToolCommons.getToolPriority(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

