/*
 * Decompiled with CFR 0.152.
 */
package thaumicperiphery.items;

import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.util.EmberInventoryUtil;
import thaumcraft.common.items.casters.CasterManager;
import thaumcraft.common.items.casters.ItemCaster;
import thaumcraft.common.items.casters.ItemFocus;
import thaumicperiphery.ThaumicPeriphery;

public class ItemCasterEmber
extends ItemCaster {
    public static final float EMBER_RATIO = 7.0f;
    DecimalFormat myFormatter = new DecimalFormat("#######.#");

    public ItemCasterEmber() {
        super("caster_ember", 0);
        this.func_77637_a(ThaumicPeriphery.thaumicPeripheryTab);
    }

    public boolean consumeVis(ItemStack is, EntityPlayer player, float amount, boolean crafting, boolean sim) {
        amount *= this.getConsumptionModifier(is, player, crafting);
        amount = (float)((int)(amount * 10.0f)) / 10.0f;
        if (EmberInventoryUtil.getEmberTotal((EntityPlayer)player) < (double)amount) {
            return false;
        }
        if (!sim) {
            EmberInventoryUtil.removeEmber((EntityPlayer)player, (double)amount);
        }
        return true;
    }

    public float getConsumptionModifier(ItemStack is, EntityPlayer player, boolean crafting) {
        float consumptionModifier = 1.0f;
        if (player != null) {
            consumptionModifier -= CasterManager.getTotalVisDiscount((EntityPlayer)player);
        }
        return Math.max(consumptionModifier, 0.1f) * 7.0f;
    }

    public void func_77663_a(ItemStack is, World w, Entity e, int slot, boolean currentItem) {
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == ThaumicPeriphery.thaumicPeripheryTab || tab == CreativeTabs.field_78027_g) {
            items.add((Object)new ItemStack((Item)this));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            float amt;
            String text = "";
            ItemStack focus = this.getFocusStack(stack);
            if (focus != null && !focus.func_190926_b() && (amt = ((ItemFocus)focus.func_77973_b()).getVisCost(focus) * 7.0f) > 0.0f) {
                text = "\u00a7r" + this.myFormatter.format(amt) + " " + I18n.func_74838_a((String)"item.Focus.cost_ember");
            }
            tooltip.add(TextFormatting.ITALIC + "" + TextFormatting.RED + I18n.func_74838_a((String)"thaumicperiphery.ember.cost") + " " + text);
        }
        if (this.getFocus(stack) != null) {
            tooltip.add(TextFormatting.BOLD + "" + TextFormatting.ITALIC + "" + TextFormatting.GREEN + this.getFocus(stack).func_77653_i(this.getFocusStack(stack)));
            this.getFocus(stack).addFocusInformation(this.getFocusStack(stack), worldIn, tooltip, flagIn);
        }
    }
}

