/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdscheduler.command.create;

import com.google.common.collect.Range;
import com.google.inject.Inject;
import com.mcsimonflash.sponge.cmdcontrol.core.CmdUtils;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.argument.Arguments;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Aliases;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Command;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Permission;
import com.mcsimonflash.sponge.cmdscheduler.command.create.Create;
import com.mcsimonflash.sponge.cmdscheduler.schedule.ClassicSchedule;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

@Aliases(value={"classic"})
@Permission(value="cmdscheduler.command.create.classic.base")
public class Classic
extends Command {
    @Inject
    private Classic(Command.Settings settings) {
        super(settings.usage(CmdUtils.usage((String)"/cmdscheduler create classic ", (Text)CmdUtils.info((String)"Classic", (String)"Creates a new task with a classic schedule.\n", (String)"", (String)"classic\n", (String)"cmdscheduler.command.create.classic.base"), (Text[])new Text[]{Create.NAME_ARG, CmdUtils.arg((boolean)false, (String)"-delay", (Text)CmdUtils.info((String)"Delay", (String)"The delay of this task.\n", (String)"Duration (in the form #d#h#m#s#ms)\n", (String)"-delay, -d", (String)"")), CmdUtils.arg((boolean)false, (String)"-interval", (Text)CmdUtils.info((String)"Interval", (String)"The interval of this task.\n", (String)"Duration (in the form #d#h#m#s#ms)\n", (String)"-interval, -i", (String)"")), CmdUtils.arg((boolean)false, (String)"-delay-ticks", (Text)CmdUtils.info((String)"DelayTicks", (String)"The delay of this task in ticks.\n", (String)"Integer (at least 0)\n", (String)"-delay-ticks, -dt", (String)"")), CmdUtils.arg((boolean)false, (String)"-interval-ticks", (Text)CmdUtils.info((String)"IntervalTicks", (String)"The interval of this task in ticks.\n", (String)"Integer (at least 0)\n", (String)"-interval-ticks, -it", (String)"")), Create.ASYNC_FLAG, Create.START_FLAG, Create.COMMAND_ARG})).elements(new CommandElement[]{Arguments.string().toElement("name"), Arguments.flags().flag(new String[]{"start"}).flag((CommandElement)Arguments.tristate().toElement("async"), new String[]{"async", "a"}).flag((CommandElement)Arguments.duration().toElement("delay"), new String[]{"delay", "d"}).flag((CommandElement)Arguments.duration().toElement("interval"), new String[]{"interval", "i"}).flag((CommandElement)Arguments.intObj().inRange(Range.atLeast((Comparable)Integer.valueOf(0))).toElement("delay-ticks"), new String[]{"delay-ticks", "dt"}).flag((CommandElement)Arguments.intObj().inRange(Range.atLeast((Comparable)Integer.valueOf(0))).toElement("interval-ticks"), new String[]{"interval-ticks", "it"}).build(), Arguments.command().toElement("command")}));
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        return Create.create(src, args, Classic::apply);
    }

    private static ClassicSchedule apply(CommandContext args) {
        ClassicSchedule.Builder builder = ClassicSchedule.builder();
        args.getOne("delay").ifPresent(builder::delay);
        args.getOne("interval").ifPresent(builder::interval);
        args.getOne("delay-ticks").ifPresent(builder::delayTicks);
        args.getOne("interval-ticks").ifPresent(builder::intervalTicks);
        return builder.build();
    }
}

