/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tile;

import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityFuelGeneratorBase;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorWaterBlocks;
import ic2.core.block.generator.container.ContainerWaterGenerator;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.FluidFilter;
import ic2.core.inventory.filters.InvertedFilter;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.helpers.AabbUtil;
import ic2.core.util.math.Box2D;
import ic2.core.util.misc.FluidHelper;
import ic2.core.util.misc.StackUtil;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityWaterGenerator
extends TileEntityFuelGeneratorBase {
    public static AabbUtil.IBlockFilter filter = new WaterFilter();
    public int water = 0;
    public int microStorage = 0;
    public static final int maxFuel = 2000;
    int config;
    float multiplier = 1.0f;

    public TileEntityWaterGenerator() {
        super(2);
        this.production = 1;
        this.maxStorage = 2;
        this.config = IC2.config.getInt("energyGeneratorWater");
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        FluidFilter filter = new FluidFilter(FluidRegistry.WATER);
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0, 1);
        handler.registerDefaultSlotsForSide(RotationList.UP, 0);
        handler.registerDefaultSlotsForSide(RotationList.ALL, 1);
        handler.registerDefaultOverride(AccessRule.None, 1);
        handler.registerInputFilter(filter, 1);
        handler.registerOutputFilter(new InvertedFilter(filter), 1);
        handler.registerInputFilter(CommonFilters.ChargeEU, 0);
        handler.registerSlotType(SlotType.Charge, 0);
        handler.registerSlotType(SlotType.FluidFuel, 1);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorWaterBlocks(this));
    }

    public int getWater() {
        return this.water;
    }

    public int getMaxWater() {
        return 25;
    }

    @Override
    public float getFuel() {
        return this.fuel;
    }

    @Override
    public float getMaxFuel() {
        return 2000.0f;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerWaterGenerator(player.field_71071_by, this);
    }

    @Override
    public Box2D getFuelBox() {
        return Ic2GuiComp.waterMillFuelBox;
    }

    @Override
    public Box2D getEnergyBox() {
        return Ic2GuiComp.generatorEnergyBox;
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.waterMill;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.waterMill;
    }

    @Override
    public ResourceLocation getOperationSoundFile() {
        return Ic2Sounds.watermillLoop;
    }

    @Override
    public boolean gainEnergy() {
        return super.gainEnergy() || this.water > 0;
    }

    @Override
    public boolean gainFuel() {
        if (!((ItemStack)this.inventory.get(1)).func_190926_b() && 2000 - this.fuel >= 500) {
            if (StackUtil.isStackEqual((ItemStack)this.inventory.get(1), Ic2Items.waterCell)) {
                this.fuel = (int)((float)this.fuel + 1000.0f / this.multiplier);
                this.production = (int)this.multiplier;
                ((ItemStack)this.inventory.get(1)).func_190918_g(1);
                return true;
            }
            FluidTank tank = new FluidTank((int)((float)((2000 - this.fuel) * 2) * this.multiplier));
            if (FluidHelper.drainContainers((IFluidHandler)tank, this, 1)) {
                this.fuel = (int)((float)this.fuel + (float)(tank.getFluidAmount() / 2) / this.multiplier);
                this.production = (int)this.multiplier;
                return true;
            }
            return false;
        }
        if (this.fuel <= 0) {
            this.flowPower();
            this.production = this.microStorage / 100;
            this.microStorage -= this.production * 100;
            if (this.production > 0) {
                ++this.fuel;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean delayActiveUpdate() {
        return true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.updateWaterCount();
        }
    }

    @Override
    public boolean needsFuel() {
        return this.fuel < 2000;
    }

    public void flowPower() {
        int adding;
        if (this.field_145850_b.func_82737_E() % 128L == 0L) {
            this.updateWaterCount();
        }
        if ((adding = (int)((double)this.water * ((double)this.config / 100.0))) > 0) {
            this.microStorage += adding;
        }
    }

    public void updateWaterCount() {
        this.water = AabbUtil.getBlockCount(this.field_145850_b, this.func_174877_v(), 1, filter, true, false, RotationList.ALL);
    }

    public static class TileEntityHVWaterGen
    extends TileEntityWaterGenerator {
        public TileEntityHVWaterGen() {
            this.production = 500;
            this.maxStorage = 2048;
            this.multiplier = 250.0f;
            this.config = IC2.config.getInt("energyGeneratorWaterHV");
        }

        @Override
        public void updateWaterCount() {
            this.water = 40 * AabbUtil.getBlockCount(this.field_145850_b, this.func_174877_v(), 2, filter, true, false, RotationList.ALL);
        }

        @Override
        public LocaleComp getBlockName() {
            return Ic2BlockLang.waterHV;
        }

        @Override
        public int getMaxWater() {
            return 4880;
        }

        @Override
        public double getWrenchDropRate() {
            return 1.0;
        }
    }

    public static class TileEntityMVWaterGen
    extends TileEntityWaterGenerator {
        public TileEntityMVWaterGen() {
            this.production = 64;
            this.maxStorage = 256;
            this.multiplier = 32.0f;
            this.config = IC2.config.getInt("energyGeneratorWaterMV");
        }

        @Override
        public void updateWaterCount() {
            this.water = 8 * AabbUtil.getBlockCount(this.field_145850_b, this.func_174877_v(), 2, filter, true, false, RotationList.ALL);
        }

        @Override
        public LocaleComp getBlockName() {
            return Ic2BlockLang.waterMV;
        }

        @Override
        public int getMaxWater() {
            return 976;
        }

        @Override
        public double getWrenchDropRate() {
            return 1.0;
        }
    }

    public static class TileEntityLVWaterGen
    extends TileEntityWaterGenerator {
        public TileEntityLVWaterGen() {
            this.production = 4;
            this.maxStorage = 32;
            this.multiplier = 4.0f;
            this.config = IC2.config.getInt("energyGeneratorWaterLV");
        }

        @Override
        public void updateWaterCount() {
            this.water = (int)(7.5 * (double)AabbUtil.getBlockCount(this.field_145850_b, this.func_174877_v(), 1, filter, true, false, RotationList.ALL));
        }

        @Override
        public LocaleComp getBlockName() {
            return Ic2BlockLang.waterLV;
        }

        @Override
        public int getMaxWater() {
            return 187;
        }

        @Override
        public double getWrenchDropRate() {
            return 1.0;
        }
    }

    public static class WaterFilter
    implements AabbUtil.IBlockFilter {
        @Override
        public boolean isValidBlock(IBlockState state) {
            return state.func_185904_a() == Material.field_151586_h;
        }

        @Override
        public boolean isValidBlock(World world, BlockPos pos) {
            return world.func_180495_p(pos).func_185904_a() == Material.field_151586_h;
        }

        @Override
        public boolean forceChunkLoad() {
            return false;
        }
    }
}

