/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.tile.MachineType;
import ic2.core.block.base.tile.TileEntityAdvancedMachine;
import ic2.core.block.machine.recipes.entries.ScrapBoxOutput;
import ic2.core.inventory.filters.MachineFilter;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.inventory.slots.SlotCustom;
import ic2.core.inventory.slots.SlotDischarge;
import ic2.core.inventory.slots.SlotOutput;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.misc.StackUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TileEntityCompactingRecycler
extends TileEntityAdvancedMachine {
    public static IMachineRecipeList.RecipeEntry entry = new IMachineRecipeList.RecipeEntry(new RecipeInputItemStack(Ic2Items.scrap, 9), new ScrapBoxOutput(23643), "Scrapbox");

    public TileEntityCompactingRecycler() {
        super(3, 10, 333);
    }

    @Override
    public IMachineRecipeList getRecipeList() {
        return ClassicRecipes.recycler;
    }

    @Override
    public MachineType getType() {
        return MachineType.recylced;
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.RecyclerGui.class;
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.compactingRecycler;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.compactingRecycler;
    }

    @Override
    public LocaleComp getSpeedName() {
        return Ic2GuiLang.machineSpeed;
    }

    @Override
    public IMachineRecipeList.RecipeEntry getOutputFor(ItemStack input) {
        if (StackUtil.isStackEqual(input, Ic2Items.scrap)) {
            return entry;
        }
        return ClassicRecipes.recycler.getRecipeInAndOutput(input, false);
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{2};
    }

    @Override
    public Slot[] getInventorySlots(InventoryPlayer player) {
        Slot[] slot = new Slot[]{new SlotDischarge(this, Integer.MAX_VALUE, 0, 56, 53), new SlotCustom(this, 1, 56, 17, new MachineFilter(this)), new SlotOutput(player.field_70458_d, this, 2, 116, 35)};
        return slot;
    }

    @Override
    public ResourceLocation getProcessSoundFile() {
        return Ic2Sounds.recyclerOp;
    }

    @Override
    public ResourceLocation getInterruptSoundFile() {
        return Ic2Sounds.interruptingSound;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (ClassicRecipes.recycler.getFilter().isItemAllowed(par1)) {
            return super.isValidInput(par1);
        }
        return false;
    }
}

