/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.special;

import ic2.core.block.machine.high.TileEntityElectricEnchanter;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.IC2Button;
import ic2.core.inventory.gui.buttons.ToggleButton;
import ic2.core.inventory.gui.buttons.ToolTipButton;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.components.special.DisplayLocaleComp;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElectricEnchanterComp
extends GuiComponent {
    public static final ItemStack enchanter = new ItemStack(Blocks.field_150381_bn);
    public static final ItemStack anvil = new ItemStack(Blocks.field_150467_bQ);
    TileEntityElectricEnchanter ench;

    public ElectricEnchanterComp(TileEntityElectricEnchanter tile) {
        super(Ic2GuiComp.nullBox);
        this.ench = tile;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.ButtonNotify, GuiComponent.ActionRequest.GuiInit, GuiComponent.ActionRequest.GuiTick, GuiComponent.ActionRequest.FrontgroundDraw);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        gui.drawCenteredString(TextFormatting.DARK_GREEN + "" + this.ench.storedExp + " / " + this.ench.neededExp, 115, 72, 0x404040);
        gui.drawCenteredString(Ic2GuiLang.enchantLevel.getLocalizedFormatted(this.ench.enchantLevel), 90, 60, 0x404040);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        gui.registerButton(new ToolTipButton(0, x + 65, y + 70, 10, 10, "-").addComponents(Arrays.asList(Ic2GuiLang.removeXP, Ic2GuiLang.getAltKey("100"), Ic2GuiLang.getShiftKey("1000"), Ic2GuiLang.getCtrlKey(Ic2GuiLang.everything.getLocalized()))));
        gui.registerButton(new ToolTipButton(1, x + 160, y + 70, 10, 10, "+").addComponents(Arrays.asList(Ic2GuiLang.addXP, Ic2GuiLang.getAltKey("10"), Ic2GuiLang.getShiftKey("100"), Ic2GuiLang.getCtrlKey("1000"))));
        gui.registerButton(new IC2Button(2, x + 35, y + 57, 30, 10, Ic2GuiLang.enchantingStart));
        gui.registerButton(new ToggleButton(3, x + 150, y + 5, 20, 20).setTextVisiblity(false, false).setIcons(enchanter, anvil).setState(this.ench.mode == 1).setNames(new DisplayLocaleComp(enchanter.func_82833_r()), new DisplayLocaleComp(anvil.func_82833_r())));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiTick(GuiIC2 gui) {
        gui.getButton((int)0).field_146124_l = this.ench.storedExp > 0 && !this.ench.started;
        gui.getButton((int)1).field_146124_l = this.ench.storedExp < 10000;
        gui.getButton((int)2).field_146124_l = this.ench.isDefined && !this.ench.started && this.ench.storedExp >= this.ench.neededExp && (this.ench.mode != 0 || this.ench.enchantLevel > 0);
        gui.getCastedButton((int)3, ToggleButton.class).setState((boolean)(this.ench.mode == 1 ? true : false)).field_146124_l = ((ItemStack)this.ench.inventory.get(6)).func_190926_b();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0 || id == 1) {
            this.ench.getNetwork().initiateClientTileEntityEvent(this.ench, id + 2, this.getType());
        } else {
            this.ench.getNetwork().initiateClientTileEntityEvent(this.ench, id - 2, 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getType() {
        if (GuiScreen.func_146271_m()) {
            return 3;
        }
        if (GuiScreen.func_146272_n()) {
            return 2;
        }
        if (GuiScreen.func_175283_s()) {
            return 1;
        }
        return 0;
    }
}

