/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.classic.audio.PositionSpec;
import ic2.core.IC2;
import ic2.core.block.misc.tile.TileEntityBarrel;
import ic2.core.block.resources.BlockRubberWood;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.platform.registry.Ic2States;
import ic2.core.util.misc.StackUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemToolTreetap
extends ItemIC2 {
    public ItemToolTreetap() {
        this.func_77625_d(1);
        this.func_77656_e(16);
        this.setUnlocalizedName(Ic2ItemLang.treeTap);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 55;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() == Ic2States.barrel.func_177230_c()) {
            if (facing.func_176736_b() == -1 || stack.func_77952_i() > 0) {
                return EnumActionResult.PASS;
            }
            TileEntity tile = worldIn.func_175625_s(pos);
            if (!(tile instanceof TileEntityBarrel)) {
                return EnumActionResult.PASS;
            }
            TileEntityBarrel barrel = (TileEntityBarrel)tile;
            if (barrel.treeTabSide != -1) {
                return EnumActionResult.PASS;
            }
            if (IC2.platform.isRendering()) {
                return EnumActionResult.PASS;
            }
            barrel.treeTabSide = facing.func_176736_b();
            barrel.updateBlock();
            IC2.achievements.issueStat(player, "beersBrewed", barrel.getStoredAmount());
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        if (state.func_177230_c() == Ic2States.rubberWood.func_177230_c()) {
            boolean server = IC2.platform.isSimulating();
            if (server && ItemToolTreetap.attemptExtract(stack, player, worldIn, pos, facing, null) == EnumActionResult.SUCCESS) {
                stack.func_77972_a(1, (EntityLivingBase)player);
                return EnumActionResult.SUCCESS;
            }
            if (!server && ((Boolean)state.func_177229_b((IProperty)BlockRubberWood.resin)).booleanValue() && state.func_177229_b((IProperty)BlockRubberWood.resinFacing) == facing) {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, new ResourceLocation("ic2", "sounds/Tools/Treetap.ogg"), true, IC2.audioManager.defaultVolume);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public static EnumActionResult attemptExtract(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, List<ItemStack> items) {
        IBlockState state = world.func_180495_p(pos);
        if (!((Boolean)state.func_177229_b((IProperty)BlockRubberWood.resin)).booleanValue() || state.func_177229_b((IProperty)BlockRubberWood.resinFacing) != side) {
            return EnumActionResult.PASS;
        }
        boolean simulate = IC2.platform.isSimulating();
        if (((Boolean)state.func_177229_b((IProperty)BlockRubberWood.collectable)).booleanValue()) {
            if (simulate) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)BlockRubberWood.collectable, (Comparable)Boolean.valueOf(false)));
                if (items != null) {
                    items.add(StackUtil.copyWithSize(Ic2Items.stickyResin.func_77946_l(), 1 + world.field_73012_v.nextInt(3) + ItemToolTreetap.getFortuneBonus(stack)));
                } else {
                    ItemToolTreetap.ejectResin(world, pos, side, world.field_73012_v.nextInt(3) + 1 + ItemToolTreetap.getFortuneBonus(stack));
                }
                world.func_175684_a(pos, state.func_177230_c(), 100);
                IC2.network.get(simulate).announceBlockUpdate(world, pos);
            }
            if (!simulate && player != null) {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, Ic2Sounds.treeTapUse, true, IC2.audioManager.defaultVolume);
            }
            return EnumActionResult.SUCCESS;
        }
        if (world.field_73012_v.nextInt(5) == 0 && simulate) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)BlockRubberWood.resin, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockRubberWood.resinFacing, (Comparable)EnumFacing.NORTH));
            IC2.network.get(simulate).announceBlockUpdate(world, pos);
        }
        if (world.field_73012_v.nextInt(5) == 0) {
            if (simulate) {
                if (items != null) {
                    items.add(StackUtil.copyWithSize(Ic2Items.stickyResin.func_77946_l(), 1 + ItemToolTreetap.getFortuneBonus(stack)));
                } else {
                    ItemToolTreetap.ejectResin(world, pos, side, 1 + ItemToolTreetap.getFortuneBonus(stack));
                }
            }
            if (simulate || player != null) {
                // empty if block
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.SUCCESS;
    }

    public static void ejectResin(World world, BlockPos pos, EnumFacing side, int quantity) {
        double ejectX = (double)pos.func_177958_n() + 0.5 + 0.3 * (double)side.func_82601_c();
        double ejectY = (double)pos.func_177956_o() + 0.5;
        double ejectZ = (double)pos.func_177952_p() + 0.5 + 0.3 * (double)side.func_82599_e();
        for (int i = 0; i < quantity; ++i) {
            EntityItem entityitem = new EntityItem(world, ejectX, ejectY, ejectZ, Ic2Items.stickyResin.func_77946_l());
            entityitem.func_174869_p();
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static int getFortuneBonus(ItemStack item) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)item);
        if (level <= 0) {
            return 0;
        }
        return field_77697_d.nextInt(level + 1);
    }
}

