/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.inventory;

import ic2.core.IC2;
import ic2.core.inventory.management.IHasHandler;
import ic2.core.inventory.management.IInventoryModifier;
import ic2.core.item.upgrades.subtypes.inventory.BaseMetaInventoryUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLimitUpgrade
extends BaseMetaInventoryUpgrade {
    @Override
    public IInventoryModifier.EffectType getEffect() {
        return IInventoryModifier.EffectType.Slot;
    }

    @Override
    public LocaleComp getName() {
        return Ic2ItemLang.itemLimiterUpgrade;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> list, boolean adv, Map<ToolTipType, List<String>> sortedToolTips) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        int result = 64;
        if (nbt.func_74764_b("Modifier")) {
            result = nbt.func_74762_e("Modifier");
        }
        list.add(Ic2InfoLang.invUpgradeStackSize.getLocalizedFormatted(result));
        List<String> ctrlTip = sortedToolTips.get((Object)ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2InfoLang.modifyStacksize.getLocalized());
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(9), Ic2InfoLang.modifyInverted.getLocalized()));
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(0), Ic2InfoLang.modifyBig.getLocalized()));
    }

    @Override
    public void onInstalling(ItemStack stack, IHasHandler.IInventoryHandler handler) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("Modifier")) {
            handler.allowOnlyOneStack();
            handler.setMaxStacksizeModifier(nbt.func_74762_e("Modifier"));
        }
    }

    @Override
    public boolean hasRightClick() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite() {
        return Ic2Icons.getTextures("i1")[169];
    }

    @Override
    public ActionResult<ItemStack> onRightClick(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (IC2.platform.isSimulating()) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
            if (!nbt.func_74764_b("Modifier")) {
                nbt.func_74768_a("Modifier", 64);
            }
            int effect = 1;
            if (IC2.keyboard.isAltKeyDown(player)) {
                effect = 10;
            }
            if (player.func_70093_af()) {
                effect *= -1;
            }
            int value = nbt.func_74762_e("Modifier");
            value = MathHelper.func_76125_a((int)(value + effect), (int)0, (int)128);
            nbt.func_74768_a("Modifier", value);
            IC2.platform.messagePlayer(player, Ic2InfoLang.invUpgradeStackSize, value);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }
}

