/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.client;

import ic2.api.classic.network.ICustomNetworkItemEventListener;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.NetworkField;
import ic2.core.IC2;
import ic2.core.network.DataEncoder;
import ic2.core.network.NetworkManager;
import ic2.core.network.buffers.InputBuffer;
import ic2.core.network.buffers.OutputBuffer;
import ic2.core.network.packets.IC2Packet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemCustomClientEventPacket
extends IC2Packet {
    String id;
    INetworkFieldData data;
    ItemStack stack;
    UUID playerID;

    public ItemCustomClientEventPacket() {
    }

    public ItemCustomClientEventPacket(ItemStack stack, String id, INetworkFieldData data, UUID player) {
        this.stack = stack;
        this.id = id;
        this.data = data;
        this.playerID = player;
    }

    @Override
    public void read(ByteBuf par1) {
        InputBuffer buffer = new InputBuffer(par1);
        this.stack = (ItemStack)DataEncoder.decode(buffer);
        this.playerID = buffer.readUUID();
        this.id = buffer.readString(NetworkField.BitLevel.Bit16);
        try {
            Class<? extends INetworkFieldData> clz = NetworkManager.idToClass.get(this.id);
            if (clz != null) {
                this.data = clz.newInstance();
                InputBuffer subBuffer = new InputBuffer(buffer.getSubBuffer());
                this.data.read(subBuffer);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void write(ByteBuf par1) {
        OutputBuffer buffer = new OutputBuffer(par1);
        DataEncoder.encode(buffer, this.stack);
        buffer.writeUUID(this.playerID);
        buffer.writeString(this.id, NetworkField.BitLevel.Bit16);
        try {
            OutputBuffer subBuffer = new OutputBuffer(Unpooled.buffer());
            this.data.write(subBuffer);
            buffer.writeBytes(subBuffer.getBuf().array());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        if (this.data == null || !(this.stack.func_77973_b() instanceof ICustomNetworkItemEventListener)) {
            throw new RuntimeException("Packet contains Incorrect Data");
        }
        if (!par1.func_110124_au().equals(this.playerID)) {
            par1 = IC2.platform.getServer().func_184103_al().func_177451_a(this.playerID);
        }
        if (par1 == null) {
            return;
        }
        ((ICustomNetworkItemEventListener)this.stack.func_77973_b()).onNetworkEvent(this.stack, par1, this.data);
    }
}

