/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.generic.meta;

import java.util.List;
import java.util.OptionalInt;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.cacheddata.type.MetaAccumulator;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.CommandException;
import me.lucko.luckperms.common.command.abstraction.GenericChildCommand;
import me.lucko.luckperms.common.command.access.ArgumentPermissions;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.command.utils.StorageAssistant;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.MutableContextSet;
import net.luckperms.api.model.data.DataMutateResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.ChatMetaNode;

public class MetaSetChatMeta
extends GenericChildCommand {
    private final ChatMetaType type;

    public static MetaSetChatMeta forPrefix() {
        return new MetaSetChatMeta(ChatMetaType.PREFIX, CommandSpec.META_SETPREFIX, "setprefix", CommandPermission.USER_META_SET_PREFIX, CommandPermission.GROUP_META_SET_PREFIX);
    }

    public static MetaSetChatMeta forSuffix() {
        return new MetaSetChatMeta(ChatMetaType.SUFFIX, CommandSpec.META_SETSUFFIX, "setsuffix", CommandPermission.USER_META_SET_SUFFIX, CommandPermission.GROUP_META_SET_SUFFIX);
    }

    private MetaSetChatMeta(ChatMetaType type, CommandSpec spec, String name, CommandPermission userPermission, CommandPermission groupPermission) {
        super(spec, name, userPermission, groupPermission, Predicates.is(0));
        this.type = type;
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, PermissionHolder target, ArgumentList args, String label, CommandPermission permission) throws CommandException {
        DataMutateResult result;
        MutableContextSet context;
        String meta;
        if (ArgumentPermissions.checkModifyPerms(plugin, sender, permission, target)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        int priority = args.getIntOrDefault(0, Integer.MIN_VALUE);
        if (priority == Integer.MIN_VALUE) {
            meta = args.get(0);
            context = args.getContextOrDefault(1, plugin);
        } else {
            if (args.size() <= 1) {
                this.sendDetailedUsage(sender);
                return CommandResult.INVALID_ARGS;
            }
            meta = args.get(1);
            context = args.getContextOrDefault(2, plugin);
        }
        if (ArgumentPermissions.checkContext(plugin, sender, permission, context) || ArgumentPermissions.checkGroup(plugin, sender, target, (ContextSet)context)) {
            Message.COMMAND_NO_PERMISSION.send(sender);
            return CommandResult.NO_PERMISSION;
        }
        target.removeIf(DataType.NORMAL, context, this.type.nodeType()::matches, false);
        if (priority == Integer.MIN_VALUE) {
            OptionalInt weight;
            MetaAccumulator metaAccumulator = target.accumulateMeta(QueryOptionsImpl.DEFAULT_CONTEXTUAL.toBuilder().context(context).build());
            priority = metaAccumulator.getChatMeta(this.type).keySet().stream().mapToInt(e -> e).max().orElse(0) + 1;
            if (target instanceof Group && (weight = target.getWeight()).isPresent() && weight.getAsInt() > priority) {
                priority = weight.getAsInt();
            }
        }
        if ((result = target.setNode(DataType.NORMAL, (Node)((ChatMetaNode.Builder)this.type.builder(meta, priority).withContext(context)).build(), true)).wasSuccessful()) {
            Message.ADD_CHATMETA_SUCCESS.send(sender, target, this.type, meta, priority, context);
            LoggedAction.build().source(sender).target(target).description("meta", "set" + this.type.name().toLowerCase(), priority, meta, context).build().submit(plugin, sender);
            StorageAssistant.save(target, sender, plugin);
            return CommandResult.SUCCESS;
        }
        Message.ALREADY_HAS_CHAT_META.send(sender, target, this.type, meta, priority, context);
        return CommandResult.STATE_ERROR;
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().from(1, TabCompletions.contexts(plugin)).complete((List<String>)((Object)args));
    }
}

