/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.group;

import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.utils.ArgumentException;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.node.types.DisplayName;
import me.lucko.luckperms.common.node.types.Weight;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.util.Predicates;
import me.lucko.luckperms.lib.adventure.text.Component;
import net.luckperms.api.actionlog.Action;
import net.luckperms.api.event.cause.CreationCause;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;

public class CreateGroup
extends SingleCommand {
    public CreateGroup() {
        super(CommandSpec.CREATE_GROUP, "CreateGroup", CommandPermission.CREATE_GROUP, Predicates.notInRange(1, 3));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, ArgumentList args, String label) {
        if (args.isEmpty()) {
            this.sendUsage(sender, label);
            return CommandResult.INVALID_ARGS;
        }
        String groupName = args.get(0).toLowerCase();
        if (!DataConstraints.GROUP_NAME_TEST.test(groupName)) {
            Message.GROUP_INVALID_ENTRY.send(sender, groupName);
            return CommandResult.INVALID_ARGS;
        }
        if (plugin.getStorage().loadGroup(groupName).join().isPresent()) {
            Message.ALREADY_EXISTS.send(sender, groupName);
            return CommandResult.INVALID_ARGS;
        }
        Integer weight = null;
        try {
            weight = args.getPriority(1);
        }
        catch (IndexOutOfBoundsException | ArgumentException exception) {
            // empty catch block
        }
        String displayName = null;
        try {
            displayName = args.get(weight != null ? 2 : 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            Group group = plugin.getStorage().createAndLoadGroup(groupName, CreationCause.COMMAND).get();
            if (weight != null) {
                group.setNode(DataType.NORMAL, (Node)Weight.builder(weight).build(), false);
            }
            if (displayName != null) {
                group.setNode(DataType.NORMAL, (Node)DisplayName.builder(displayName).build(), false);
            }
            plugin.getStorage().saveGroup(group);
        }
        catch (Exception e) {
            plugin.getLogger().warn("Error whilst creating group", e);
            Message.CREATE_ERROR.send(sender, (Component)Component.text((String)groupName));
            return CommandResult.FAILURE;
        }
        Message.CREATE_SUCCESS.send(sender, (Component)Component.text((String)groupName));
        LoggedAction.build().source(sender).targetName(groupName).targetType(Action.Target.Type.GROUP).description("create").build().submit(plugin, sender);
        return CommandResult.SUCCESS;
    }
}

